#!/bin/bash

# 检查/etc/sysctl.conf里是否已存在kernel.pid_max=语句，如果存在则先注释再追加
function checkpidexist()
{
    find_res=$(cat /etc/sysctl.conf | grep -E "^kernel.pid_max=")
    if [ "$find_res" != "" ];then
        for i in $find_res;do
            sed -i "s/^$i/#&/" /etc/sysctl.conf
        done
    fi
    echo "kernel.pid_max=$1" >> /etc/sysctl.conf
}

function SetTempPidMax()
{
    # 默认值为4194303
    pid_max=${1:-'4194303'}
    # 如果传参先判断参数是否有效
    if [ ! $(grep '^[[:digit:]]*$' <<< $pid_max) ];then
        log "ERROR: Pid_Max parameter is invalid" error
        return 1
    fi
    echo $pid_max > /proc/sys/kernel/pid_max
    # 判断是否修改成功
    if [ $(cat /proc/sys/kernel/pid_max) -eq ${pid_max} ];then
        log "Set pid_max: $pid_max   [OK]" warn
        return 0
    else
        log "ERROR: Set pid_max Fail" error
        return 1
    fi
}

function SetPersistentPidMax()
{
    pid_max=${1:-'4194303'}
    # 如果传参先判断参数是否有效
    if [ ! $(grep '^[[:digit:]]*$' <<< $pid_max) ];then
        log "ERROR: Pid_Max parameter is invalid" error
        return 1
    fi
    checkpidexist $pid_max
    sysctl -p >/dev/null
    # 判断是否修改成功
    if [ $(cat /proc/sys/kernel/pid_max) -eq $pid_max ];then
        log "Set pid_max: $pid_max   [OK]" warn
        return 0
    else
        log "ERROR: Set pid_max Fail" error
        return 1
    fi
}