#!/bin/bash

# 检查/etc/sysctl.conf里是否已存在fs.file语句，如果存在则先注释后追加
function checkfilemaxexist()
{
    find_res=$(cat /etc/sysctl.conf | grep -E "^fs.file")
    if [ "$find_res" != "" ];then
        for i in $find_res;do
            sed -i "s/^$i/#&/" /etc/sysctl.conf
        done
    fi
    echo "fs.file-max=$1" >> /etc/sysctl.conf
}

function SetTempFileMax()
{
    # 查看修改值
    file_max=$(cat /proc/meminfo | grep MemTotal | awk '{print $2}')
    echo $file_max > /proc/sys/fs/file-max
    # 判断是否修改成功
    if [ $(cat /proc/sys/fs/file-max) -eq $file_max ];then
        log "Set file-max: $file_max    [OK]" warn
        return 0
    else
        log "Set file-max Fail" error
        return 1
    fi
}

function SetPersistentFileMax()
{
    # 查看修改值
    file_max=$(cat /proc/meminfo | grep MemTotal | awk '{print $2}')
    checkfilemaxexist $file_max
    sysctl -p >/dev/null
    # 判断是否修改成功
    if [ $(cat /proc/sys/fs/file-max) -eq $file_max ];then
        log "Set file-max: $file_max    [OK]" warn
        return 0
    else
        log "ERROR: Set file-max Fail" error
        exit 1
    fi
}