#!/bin/bash
# Set read_ahead_kb & nr_requests

# 设置read_ahead_kb
function SetDiskReadAheadKb()
{
    # 默认参数值为128
    read_ahead_kb=${1:-'128'}
    # 如果有参数的话先判断传入的参数是否有效
    if [ ! $(grep '^[[:digit:]]*$' <<< $read_ahead_kb) ];then
        log "ERROR: Read_Ahead_Kb parameter is invalid" error
        return 1
    else
        # 循环遍历每个数据盘修改read_ahead_kb参数
        for i in ${datadisk[*]}
        do
            echo $read_ahead_kb > /sys/block/$i/queue/read_ahead_kb
            res=$(cat /sys/block/$i/queue/read_ahead_kb)
            # 判断修改后的read_ahead_kb参数值是否与传入值一致，如果一致，则输出修改完成提示
            if [ $res -eq $read_ahead_kb ];then
                log "Set $i read_ahead_kb: $res  [OK]" warn
            else
                log "ERROR: Set $i read_ahead_kb Fail" error
                return 1
            fi
        done
    fi
    return 0
}

# 设置nr_requests
function SetDiskNrRequests()
{
    # 默认参数值为512
    nr_requests=${1:-'512'}
    # 如果有参数的话先判断传入的参数是否有效
    if [ ! $(grep '^[[:digit:]]*$' <<< $nr_requests) ];then
        log "ERROR: Nr_Requests parameter is invalid" error
        return 1
    else
        # 循环遍历每个数据盘修改nr_requests参数
        for i in ${datadisk[*]}
        do
            echo $nr_requests > /sys/block/$i/queue/nr_requests
            res=$(cat /sys/block/$i/queue/nr_requests)
            # 判断修改后的nr_requests参数值是否与传入值一致，如果一致，则输出修改完成提示
            if [ $res -eq $nr_requests ];then
                log "Set $i nr_requests: $res  [OK]" warn
            else
                log "ERROR: Set $i nr_requests Fail" info
                return 1
            fi
        done
    fi
    return 0
}

function Permanently()
{
    datadisk=($dataDevList)
    SetDiskReadAheadKb $1
    SetDiskNrRequests $2
    log "Set Disk Permanently          [OK]" warn
    return 0
}
