#!/bin/bash

function SetCephTcmallocMB()
{
    # 默认值为512MB
    tcmallocMB=${1:-'512'}
    # 如果有传入参数先判断参数是否有效
    if [ $(grep '^[[:digit:]]*$' <<< $tcmallocMB) ];then
        # MB转换为BYTES
        ((tcmalloc=$tcmallocMB*1024*1024))
        # 把/etc/sysconfig/ceph文档中TCMALLOC_MAX_TOTAL_THREAD_CACHE_BYTES值改为新值
        sed -i "/TCMALLOC_MAX_TOTAL_THREAD_CACHE_BYTES/c TCMALLOC_MAX_TOTAL_THREAD_CACHE_BYTES=$tcmalloc" /etc/sysconfig/ceph
        # 判断/etc/sysconfig/ceph文档中的值是否与传入值一致，一致则输出修改成功
        if [ $(cat /etc/sysconfig/ceph | grep 'TCMALLOC_MAX_TOTAL_THREAD_CACHE_BYTES' | awk -F'=' '{print$2}') -eq $tcmalloc ];then
            log "Set tcmalloc : $tcmalloc   [OK]" warn
        else
            log "ERROR: Set tcmalloc Fail" error
            return 1
        fi
    else
        log "ERROR: Tcmalloc parameter is invalid" error
        return 1
    fi
}
