#!/bin/bash
# 优化汇总

LOG_FILE=/var/log/ceph_local_install.log
SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/osSetSwappiness.sh
source $SCRIPT_HOME/osSetPidMax.sh
source $SCRIPT_HOME/osSetFileMax.sh
source $SCRIPT_HOME/osSetDisk.sh
source $SCRIPT_HOME/osSetCephTcmallocMB.sh
source $SCRIPT_HOME/osHelp.sh
source $SCRIPT_HOME/para.cfg
source $SCRIPT_HOME/../common/common.sh

function Temp()
{
    SetTempFileMax
    SetTempSwappiness $swap
    SetTempPidMax $pid_max
    SetDiskReadAheadKb $read_ahead_kb
    SetDiskNrRequests $nr_requests
    SetCephTcmallocMB $tcmalloc
}

function Pmnt()
{
    SetPersistentFileMax
    SetPersistentSwappiness $swap
    SetPersistentPidMax $pid_max
    Permanently $read_ahead_kb $nr_requests
    SetCephTcmallocMB $tcmalloc
}

case $1 in
    "-a" | "--all" )
        Temp
        ;;
    "-A" | "--All" )
        Pmnt
        ;;
    "-s" | "--TempSwappiness" )
        SetTempSwappiness $2
        ;;
    "-S" | "--PersistentSwappiness" )
        SetPersistentSwappiness $2
        ;;
    "-p" | "--TempPidMax" )
        SetTempPidMax $2
        ;;
    "-P" | "--PersistentPidMax" )
        SetPersistentPidMax $2
        ;;
    "-f" | "--TempFileMax" )
        SetTempFileMax
        ;;
    "-F" | "--PersistentFileMax" )
        SetPersistentFileMax
        ;;
    "-m" | "--TempMTU" )
        SetTempMTU $2 $3
        ;;
    "-M" | "--PersistentMTU" )
        SetPersistentMTU $2 $3
        ;;
    "-r" | "--readaheadkb" )
        SetDiskReadAheadKb $2
        ;;
    "-n" | "--nrrequests" )
        SetDiskNrRequests $2
        ;;
    "-D" | "--Datadisk")
        Permanently $2 $3
        ;;
    "-T" | "Tcmalloc" )
        SetCephTcmallocMB $2
        ;;
    "--help" | "-h" | "help" )
        print_help
        ;;
    "*" )
        echo "Unkown parameter"
        print_help
        exit 1
        ;;
esac