#!/bin/bash

function print_help()
{
    echo "Usage: sh $0 [OPTIONS...]"
    echo "Example: sh $0 -s 128"
    echo "Example: sh $0 -M 1500 eth3"
    echo ""
    echo "Options:"
    echo "-a, --all                        set All OS optimization temporarily, change parameters need to modify para.cfg"
    echo "-A, --All                        set All OS optimization permanently, same usage with -a"
    echo "-s, --TempSwappiness NUM         set vm.swappiness=NUM temporarily, defaluts=0"
    echo "-S, --PersistentSwappiness NUM   set vm.swappiness=NUM permanently, no defaluts, must input parameter"
    echo "-p, --TempPidMax NUM             set pid_max=NUM temporarily, defaluts=4194303"
    echo "-P, --PersistentPidMax NUM       set pid_max=NUM permanently, defaults=4194303"
    echo "-f, --TempFileMax                set file-max temporarily"
    echo "-F, --PersistentFileMax          set file-max permanently"
    echo "-m, --TempMTU NUM dev            set Net-Device's MTU=NUM temporarily, defaults=9000; if dev not setted, set all netdevices which state is UP in default; if need to set particular dev, must input NUM first"
    echo "-M, --PersistentMTU NUM dev      set netdevice's MTU=NUM permanently,defaults=9000, same usage with -m"
    echo "-r, --readaheadkb NUM            set Data-Disk read_ahead_kb=NUM temporarily, defaults=128"
    echo "-n, --nrrequests NUM             set Data-Disk nr_requests=NUM temporarily, defaults=512"
    echo "-D, --Datadisk NUM1 NUM2         set Data-Disk read_ahead_kb=NUM1 nr_requests=NUM2 permanently, defaluts read_ahead_kb=128,nr_requests=512"
    echo "-T, --Tcmalloc NUM               set TCMALLOC_MAX_TOTAL_THREAD_CACHE_BYTES=NUM*1024*1024, defaults=512"
    exit 0
}