#!/bin/bash
# 调优汇总

function print_help()
{
    echo "Usage: sh $0 [OPTIONS...]"
    echo "Example: sh $0 -A"
    echo ""
    echo "Options:"
    echo "-A            execute all optimization-script, all the parameter come from para.cfg"
    echo "-B            execute script to bind core physically"
    echo "-C            execute script to optimize ceph configration"
    echo "-F            execute script to optimize net and storage numa affinity"
    echo "-N            execute script to optimize 1822-network-card"
    echo "-P            execute script to optimize ceph-pg"
    echo "-I            execute script to optimize SIrq affinity"
    exit 0
}

if [ $# -eq 0 ];then
    echo "Need Option"
    print_help
    exit 1
fi

SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/para.cfg
source $SCRIPT_HOME/osOptimization.sh
source $SCRIPT_HOME/1822Optization.sh
source $SCRIPT_HOME/bindCorePhy.sh
source $SCRIPT_HOME/cephConfOpt.sh
source $SCRIPT_HOME/netStorageNumaAffi.sh
source $SCRIPT_HOME/smartIrqAffi.sh
source $SCRIPT_HOME/pgOptimization.sh

function getPara() {
    hostname=$(hostname)
    source $SCRIPT_HOME/../conf/$hostname
    # dev_name_arry & dev_name_1822
    for i in ${public_ethlist[*]}
    do
      dev_name_arry=(${dev_name_arry[*]} $i)
      dev_name_1822=(${dev_name_1822[*]} $i)
    done
    for i in ${cluster_ethlist[*]}
    do
      dev_name_arry=(${dev_name_arry[*]} $i)
      dev_name_1822=(${dev_name_1822[*]} $i)
    done
    # hostnum
    dev_array=(${dataDevList///}) # 将dataDevList字符以空格来切分成数组
    hostnum=${#dev_array[@]}
    # osdperhost
    osdperhost=$osd_per_dev
}

function ALL()
{
  getPara
  Pmnt  # osOptimization.sh -A
  set1822   # 1822Optization.sh
  #setBind   # bindCorePhy.sh
  #setCephConf   # cephConfOpt.sh
  #setNvme   # netStorageNumaAffi.sh
  #setNetCard    # netStorageNumaAffi.sh
  #setIrq    # smartIrqAffi.sh
  #pgOptimization    # pgOptimization.sh
  #primaryPgOptimization   # pgOptimization.sh
}

case $1 in
    "-A")
        ALL
        ;;
    "-B")
        getPara
        setBind   # bindCorePhy.sh
        ;;
    "-C")
        setCephConf   # cephConfOpt.sh
        ;;
    "-F")
        setNvme   # netStorageNumaAffi.sh
        setNetCard    # netStorageNumaAffi.sh
        ;;
    "-N")
        getPara
        set1822   # 1822Optization.sh
        ;;
    "-P")
        getPara
        pgOptimization    # pgOptimization.sh
        primaryPgOptimization   # pgOptimization.sh
        ;;
    "-I")
        setIrq    # smartIrqAffi.sh
        ;;
    "-h" | "--help" | "-H" | "help")
        print_help
        ;;
    "*" )
        echo "Unkown Parameter"
        print_help
        exit 1
        ;;
esac
