#! /bin/bash
# 网络和存储的NUMA亲和优化

# 参数为名称数组
function numa_affi_opt()
{
    name_arr=($1)
    numa_node0=()
    numa_node1=()
    numa_node2=()
    numa_node3=()
    # 遍历所有的闪存盘/网卡，查看对应的初始numa_node节点
    for i in ${name_arr[*]}
    do
        each_numa_node=`cat /sys/class/$addr/$i/device/numa_node`
        if [ "$each_numa_node" == 0 ];then
            numa_node0=(${numa_node0[*]} $i)
        elif [ "$each_numa_node" == 1 ];then
            numa_node1=(${numa_node1[*]} $i)
        elif [ "$each_numa_node" == 2 ];then
            numa_node2=(${numa_node2[*]} $i)
        elif [ "$each_numa_node" == 3 ];then
            numa_node3=(${numa_node3[*]} $i)
        else
            echo "ERROR: $i NUMA_NODE is $each_numa_node"
        fi
    done

    if [ ${#numa_node0[@]} -eq ${#numa_node1[@]} ] && [ ${#numa_node2[@]} -eq ${#numa_node3[@]} ];then
        echo "count numa_node0: ${#numa_node0[@]}"
        echo "count numa_node1: ${#numa_node1[@]}"
        echo "count numa_node2: ${#numa_node2[@]}"
        echo "count numa_node3: ${#numa_node3[@]}"
        return 0
    fi
    node0_num=`expr ${#numa_node0[@]} - ${#numa_node1[@]}`
    node2_num=`expr ${#numa_node2[@]} - ${#numa_node3[@]}`
    # 将初始numa_node在0节点上的网卡均分给1节点
    for((i=`expr $node0_num / 2`;i<`expr $node0_num`;i++))
    do
        echo "1" > /sys/class/$addr/${numa_node0[i]}/device/numa_node
        echo "${numa_node0[i]} Set NODE1 Done"
    done
    # 将初始numa_node在2节点上的网卡均分给3节点
    for((i=`expr $node2_num / 2`;i<`expr $node2_num`;i++))
    do
        echo "3" > /sys/class/$addr/${numa_node2[i]}/device/numa_node
        echo "${numa_node2[i]} Set NODE3 Done"
    done

    # 检查
    node0=0
    node1=0
    node2=0
    node3=0
    for i in ${name_arr[*]}
    do
        each_numa_node=`cat /sys/class/$addr/$i/device/numa_node`
        if [ "$each_numa_node" == 0 ];then
            let node0=node0+1
        elif [ "$each_numa_node" == 1 ];then
            let node1=node1+1
        elif [ "$each_numa_node" == 2 ];then
            let node2=node2+1
        elif [ "$each_numa_node" == 3 ];then
            let node3=node3+1
        else
            return 1
        fi
    done
    if [ "$node0" == "$node1" ] && [ "$node2" == "$node3" ];then
        return 0
    else
        return 1
    fi
}

function setNvme()
{
  # 查询闪存盘
  name_nvme=`ls /sys/class/nvme/ | grep -E "^nvme"`
  if [ $? -ne 0 ];then
      echo "Can't find nvme disk"
  else
      addr='nvme'
      numa_affi_opt "${name_nvme[*]}"
      if [ $? != 0 ];then
          echo "Storage NUMA Affinity Optization Failed"
      else
          echo "Storage NUMA Affinity Optization Success"
      fi
  fi
}

function setNetCard()
{
  # 筛选名称以en开头的网卡设备
  name_eth=`ls /sys/class/net/ | grep -E "^en"`
  if [ $? -ne 0 ];then
      echo "Can't find net-device"
  else
      addr='net'
      numa_affi_opt "${name_eth[*]}"
      if [ $? != 0 ];then
          echo "Net NUMA Affinity Optization Failed"
      else
          echo "Net NUMA Affinity Optization Success"
      fi
  fi
}
