#!/bin/bash
# ceph优化——配置优化

source $SCRIPT_HOME/para.cfg
source $SCRIPT_HOME/../conf/common.cfg

function is_digital()
{
	expr $1 "+" 10 &> /dev/null
	if [ $? -ne 0 ]; then
		return 1
	else
		return 0
	fi
}

# 检查IP是否合法
function check_ip()
{
    IP=$1
    VALID_CHECK=$(echo $IP | awk -F'.' '$1<=255&&$2<=255&&$3<=255&&$4<=255{print "yes"}')
    if echo $IP | grep -E "^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$" > /dev/null;then
        if [ ${VALID_CHECK:-no} == "yes" ];then
            return 0
        else
            return 1
        fi
    else
        return 1
    fi
}

function ceph_conf_opt()
{
    pn=`cat $ceph_conf_addr | grep "^public_network"`
    cn=`cat $ceph_conf_addr | grep "^cluster_network"`
    if [ ! $pn ];then
        sed -i "s/^public_network/#&/" $ceph_conf_addr
    fi
    if [ ! $cn ];then
        sed -i "s/^cluster_network/#&/" $ceph_conf_addr
    fi
    echo "public_network = $public_net" >> $ceph_conf_addr
    echo "cluster_network = $cluster_net" >> $ceph_conf_addr
    
    # osd绑核——自动亲和场景
    affi_code=("osd_numa_auto_affinity=true" "osd_numa_node=-1" "osd_numa_prefer_iface")
    for i in ${affi_code[*]}
    do
        if [ ! $(cat $ceph_conf_addr | grep "$i") ];then
            echo "" >> $ceph_conf_addr
            echo "$i" >> $ceph_conf_addr
        fi
    done
}

function setCephConf()
{
  ceph_conf_addr=`find / -name "ceph.conf"`

  p_ip=`echo $public_net | awk -F'/' '{print $1}'`
  check_ip $p_ip
  if [ $? -ne 0 ];then
      echo "Invalid $public_net, Please check again(ex:192.168.1.1/24)"
      return 1
  fi
  p_seg=`echo $public_net | awk -F'/' '{print $2}'`
  is_digital $p_seg
  if [ $? -ne 0 ];then
      echo "Invalid $public_net, Please check again(ex:192.168.1.1/24)"
      return 1
  fi

  c_ip=`echo $cluster_net | awk -F'/' '{print $1}'`
  check_ip $c_ip
  if [ $? -ne 0 ];then
      echo "Invalid $public_net, Please check again(ex:192.168.1.1/24)"
      return 1
  fi
  c_seg=`echo $cluster_net | awk -F'/' '{print $2}'`
  is_digital $c_seg
  if [ $? -ne 0 ];then
      echo "Invalid $public_net, Please check again(ex:192.168.1.1/24)"
      return 1
  fi

  if [ ! $ceph_conf_addr ];
  then
      echo "can't find ceph.conf"
      exit 1
  else
      ceph_conf_opt
      if [ $? -eq 0 ];then
          echo "ceph.conf optimization done"
      else
          echo "ceph.conf optimization failed"
      fi
  fi
}