#!/bin/bash
# 物理磁盘绑核
SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/para.cfg

function is_invalid()
{
    if [ ! $1 ];then
        echo "Please input a name of Net_Driver"
        return 1
    fi
    if [[ $(ip a | awk -F': ' '/state/{print$2}') != *$1* ]];then
        echo "ERROR:Net-Device is not exist"
        return 1
    fi
    return 0
}

function bindcorephy()
{
    numa_node=`cat /sys/class/net/$device/device/numa_node`
    cpu_range=`lscpu | grep "NUMA node$numa_node" | awk '{print$NF}'`
    cpu_start=`echo $cpu_range | awk -F'-' '{print $1}'`
    cpu_end=`echo $cpu_range | awk -F'-' '{print $2}'`
    num_cpus=`lscpu | grep "^CPU(s)" | awk '{print $NF}'`
    cpu_arr=()
    # 如果该节点的cpu开始值为0，那剩余的cpu区间就是（初始值+1，总值）
    if [ $cpu_start -eq 0 ];then
        let cpu_start=cpu_end+1
        cpu_end=$num_cpus
        tmp_arr=`seq $cpu_start $cpu_end`
        cpu_arr=(${tmp_arr[@]})
    else
        # 开始值不等于0，剩余区间就是（0，开始值-1）和（末尾值+1，总值）
        let cpu_start_new=cpu_end+1
        let cpu_end_new=cpu_start-1
        tmp_arr1=`seq 0 $cpu_end_new`
        tmp_arr2=`seq $cpu_start_new $num_cpus`
        cpu_arr=(${tmp_arr1[@]} ${tmp_arr2[@]})
    fi
    # 获取osd对应的进程pid
    pid=`ps -ef | grep osd | grep -v grep | awk '{print $2}'`
    # 将所有的CPU号以,拼接：1,2,3,4...
    corelist=`echo ${cpu_arr[@]} | sed 's/ /,/g'`
    # 将进程和线程都绑到core上
    for i in $pid
    do
        taskset -apc $corelist $i
    done
}

function setBind()
{
  for device in ${dev_name_arry[@]}
  do
      is_invalid $device
      if [ $? -eq 0 ];then
          echo "Start Set: $device"
          bindcorephy
          if [ $? -eq 0 ];then
              echo "Set $device       [OK]"
          else
              echo "Set $device falied"
          fi
      fi
  done
}