#!/bin/bash
# 1822优化
SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/para.cfg

function optimization_set_1822()
{
	log "device: $device" info
	# 修改网卡的接收/发送环形参数
	ethtool -G $device rx 4096 tx 4096
	# 修改网卡Offload参数的状态
	ethtool -K $device lro on
	
	hinicadm lro -i $hinic_number -x 0 -n 32
	hinicadm lro -i $hinic_number -x 1 -n 32
	hinicadm lro -i $hinic_number -x 2 -n 32
	hinicadm lro -i $hinic_number -x 3 -n 32
	hinicadm lro -i $hinic_number -t 256
}


function check_hinic()
{
  #Check if hinic install
  hinic_mod=`lsmod | grep hinic | awk '{print $1}'`
  if [ "$hinic_mod" == "hinic" ];then
    # 卸载旧版本
    rmmod hinic
  fi
  # 加载新版本
  modprobe hinic

  if [ ! -e "/etc/modprobe.d/hinic.conf" ];then
    touch /etc/modprobe.d/hinic.conf
  fi
  if [ ! $(cat /etc/modprobe.d/hinic.conf | grep -E '^options hinic rx_buff=8$') ];then
    echo "options hinic rx_buff=8" > /etc/modprobe.d/hinic.conf
  fi
}

function set1822()
{
  ## Traverse the device
  for device in ${dev_name_1822[@]}
  do
    # 判断device是否是1822网卡
    ethtool -i $device | grep 'hinic'
    if [[ $? -ne 0 ]]
    then
      log "$device is not 1822 Network-Card" info
      continue
    else
      log "Start set :$device ...." info
      #get pci-bus address
      pci_addr=`ethtool -i $device | grep 'bus-info' | awk '{print $2}'`
      hinic_number=`ls /sys/bus/pci/drivers/hinic/$pci_addr| grep 'hinic'`
      optimization_set_1822
      log "Set $device 		[OK]" warn
    fi
  done
  return 0
}
