#!/bin/bash
#
# install all ceph in hosts
# ceph hosts and client in conf/common.conf
#

SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/env_ready/env.cfg
source $SCRIPT_HOME/conf/common.cfg
LOG_FILE=/var/log/ceph_optimize.log
local_log=/var/log/ceph_local_optimize.log

remote_user=root
remote_path="/home/install/"

source $SCRIPT_HOME/common/common.sh

log "@@@start exec optimize@@@"
for ((i=0;i<${#managerips[*]};i++))
do
  #判断是否是server，只有server端需要做优化设置
  if echo "${servername[@]}" | grep -w ${hostnames[i]} &>/dev/null; then
    log "###start to optimize on ${managerips[i]} id machine###" info
    exec_remote_client ${managerips[i]} "sh ${remote_path}/scripts/optimize/optimizeAll.sh -A"
    [[ $? -ne 0 ]]  && log "optimize on ${managerips[i]} machine failed" error  && exit 1
    log "###end install on ${managerips[i]} id machine###" info
  fi
done
log "install all hosts success" info
