#!/bin/bash
#
# install all ceph in hosts
# ceph hosts and client in conf/common.conf
#

SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/env_ready/env.cfg
source $SCRIPT_HOME/conf/common.cfg
LOG_FILE=/var/log/ceph_install.log
remote_log=/var/log/ceph_local_install.log

remote_user=root
remote_path="/home/install/"

source $SCRIPT_HOME/common/common.sh


function if_local_machine()
{
  ip add show | grep $1
  [[ $? -ne 0 ]]  && return 0
  return 1
}

for ((i=0;i<${#managerips[*]};i++))
do
  if_local_machine ${managerips[i]}
  res=$?
  log "start install on ${managerips[i]} firstnode $res" debug
  exec_remote_client ${managerips[i]} "sh ${remote_path}scripts/env_ready/installLocal.sh ${hostnames[i]} $res"
  [[ $? -ne 0 ]]  && log "install on ${managerips[i]} machine failed" error  && exit 1
  log "end install on ${managerips[i]} id machine" debug
done

for ((i=0;i<${#managerips[*]};i++))
do
  exec_remote_client ${managerips[i]} "sh ${remote_path}scripts/env_ready/remoteCmdCheck.sh"
done

log "install all hosts success" info
exit 0
