#!/bin/bash

SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
LOG_FILE=/var/log/ceph_autotest.log #日志文件路径
source $SCRIPT_HOME/../common/common.sh
source $SCRIPT_HOME/../conf/common.cfg
remote_user=root

if [ $# -lt 1 ]; then
    log "Usage: $0 <install> <package-path> | <uninstall>" error
    exit 1
fi

if [ $1 = "install" ]
then
    if [ $# -lt 2 ]; then
        log "Usage: $0 <install> <package-path>" error
        exit 1
    fi
    for node_ip in ${server[*]}
    do
        exec_remote_client ${node_ip} "mkdir -p /home/accelerator"
        scp -r ${2}/* ${remote_user}@${node_ip}:/home/accelerator
        [[ $? -ne 0 ]] && log "scp -r ${2}/* ${remote_user}@${node_ip}:/home/accelerator" error && exit 1
    done
fi

for node_ip in ${server[*]}
do
    scp $SCRIPT_HOME/../common/common.sh $SCRIPT_HOME/accelerator.sh ${node_ip}:/root/
    exec_remote_client ${node_ip} "sh /root/accelerator.sh $1 /home/accelerator"
    [[ $? -ne 0 ]] && log "${node_ip}: sh /root/accelerator.sh $1" error && exit 1
done

if [ $1 = "uninstall" ]
then
    for node_ip in ${server[*]}
    do
        exec_remote_client ${node_ip} "rm -rf /home/accelerator"
        exec_remote_client ${node_ip} "rm -f /root/common.sh /root/accelerator.sh"
    done
fi

exit 0