#!/bin/bash

accelerator_version="1.2.10" #加速器版本号
accelerator_os="centos7.6" #os
rpm_totalnum=7 #rpm包个数 用于校验
src_totalnum=3 #src包个数 用于校验
install_koname=("uacce" "hisi_hpre" "hisi_sec2" "hisi_rde" "hisi_zip") #安装内核驱动模块名称,按照安装顺序排列
uninstall_koname=("hisi_sec2" "hisi_zip" "hisi_hpre" "hisi_rde" "hisi_qm" "uacce") #卸载内核驱动模块名称，按照卸载顺序排列
install_soname=("libwd") #安装用户态驱动模块名称
driver_src="Kunpeng_KAE_driver" #驱动源码包名称
driver_dirname=("kae_driver" "warpdrive") #驱动源码包目录
zlib_patch="KAEzip" #zlib patch包名称
centos7_zlib_version="1.2.7" #centos7.6 zlib版本
elseos_zlib_version="1.2.11" #其他os zlib版本
zlib_install_path="/usr/local/zlib" #zlib安装路径
output_path="/dev/null" #中间信息输出路径

SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
LOG_FILE=/var/log/ceph_accelerator.log #日志文件路径
source $SCRIPT_HOME/common.sh

rpm_install()
{
    for rpmname in ${install_koname[*]}
    do
        if [ -e ${rpmname}-${accelerator_version}-*.${accelerator_os}.aarch64.rpm ]; then
            rpm -ivh ${rpmname}-${accelerator_version}-*.${accelerator_os}.aarch64.rpm >> $output_path
        else 
            log "${rpmname}-${accelerator_version}-*.${accelerator_os}.aarch64.rpm not exist" error
            return 1
        fi
    done

    for rpmname in ${install_soname[*]}
    do 
        if [ -e ${rpmname}-${accelerator_version}-*.${accelerator_os}.aarch64.rpm ]; then
            rpm -ivh ${rpmname}-${accelerator_version}-*.${accelerator_os}.aarch64.rpm >> $output_path
        else 
            log "${rpmname}-${accelerator_version}-*.${accelerator_os}.aarch64.rpm not exist" error
            return 1
        fi
    done

    for modname in ${install_koname[*]}
    do
        modprobe $modname
    done

    for modname in ${install_koname[*]}
    do
        if [ `lsmod | grep uacce | grep $modname | wc -l` -eq 0 ]; then
            log "lsmod not found uacce | $modname ${LINENO}" error
            return 1
        fi
    done

    log "rpm_install success" warn
    return 0
}

src_install()
{
    #gcc、make检查
    gcc --version
    [[ $? -ne 0 ]] && log "gcc not install" error && return 1
    make --version
    [[ $? -ne 0 ]] && log "make not install" error && return 1
    tar --version
    [[ $? -ne 0 ]] && log "tar not install" error && return 1

    #源码安装
    if [ -e ${driver_src}-${accelerator_version}.tar.gz ]; then
        tar -zxvf ${driver_src}-${accelerator_version}.tar.gz > $output_path
        if [ $? -eq 0 ]; then
            cd $package_path/${driver_src}
            for dirname in ${driver_dirname[*]}
            do
                cd $package_path/${driver_src}/$dirname
                if [ -e "autogen.sh" ]; then
                    sh autogen.sh > $output_path
                    ./configure > $output_path
                fi
                make;make install
            done
        else
            log "tar -zxvf ${driver_src}-${accelerator_version}.tar.gz failed ${LINENO}" error
            return 1
        fi
    else
        log "${driver_src}-${accelerator_version}.tar.gz not exist" error
        return 1
    fi

    for modname in ${install_koname[*]}
    do
        modprobe $modname
    done

    for modname in ${install_koname[*]}
    do
        if [ `lsmod | grep uacce | grep $modname | wc -l` -eq 0 ]; then
            log "lsmod not found uacce | $modname ${LINENO}" error
            return 1
        fi
    done

    log "src_install success" warn
    return 0
}

zlib_patch()
{
    patch --version
    [[ $? -ne 0 ]] && log "patch not install" error && return 1
    if [ -e ${zlib_patch}-${accelerator_version}.tar.gz ]; then
        tar -zxvf ${zlib_patch}-${accelerator_version}.tar.gz >> $output_path
        if [ $? -eq 0 ]; then
            if [ -e zlib-${centos7_zlib_version}*.src.rpm ] && [ ${accelerator_os} = "centos7.6" ]; then
                rpm -i zlib-${centos7_zlib_version}*.src.rpm >> $output_path
                [[ $? -ne 0 ]] && log "rpm -i zlib-${centos7_zlib_version}*.src.rpm" error && return 1
                mv /root/rpmbuild/SOURCES/zlib-1.2* $package_path/${zlib_patch}
                cd $package_path/${zlib_patch}
                tar -jxvf zlib-${centos7_zlib_version}.tar.bz2 >> $output_path
                cd $package_path/${zlib_patch}/zlib-${centos7_zlib_version}
                patch -Np1 < ../zlib-1.2.*-minizip-fixuncrypt.patch >> $output_path
                patch -Np1 < ../zlib-1.2.*-z-block-flush.patch >> $output_path
                patch -Np1 < ../zlib-1.2.*-fix-serious-but-very-rare-decompression-bug-in-inftr.patch >> $output_path
                patch -Np1 < ../zlib-1.2.*-Fix-bug-where-gzopen-gzclose-would-write-an-empty-fi.patch >> $output_path
                patch -Np1 < ../kunpeng_zlib_centos7.6_${accelerator_version}.patch >> $output_path
                ./configure --prefix=${zlib_install_path} >> $output_path
                make clean >> $output_path
                make >> $output_path
                make install >> $output_path
                if [ -e ${zlib_install_path}/lib/libz.so.${centos7_zlib_version} ];then
                    mv /lib64/libz.so.1 /lib64/libz.so.bak
                    ln -s ${zlib_install_path}/lib/libz.so.${centos7_zlib_version} /lib64/libz.so.1
                else
                    log "${zlib_install_path}/lib/libz.so.${centos7_zlib_version} not exist" error
                fi
            elif [ -e zlib-${elseos_zlib_version}.tar.gz ]; then
                cp $package_path/zlib-${elseos_zlib_version}.tar.gz $package_path/${zlib_patch}
                cd $package_path/${zlib_patch}
                tar -zxvf zlib-${elseos_zlib_version}.tar.gz >> $output_path
                cd $package_path/${zlib_patch}/zlib-${elseos_zlib_version}
                patch -Np1 < ../kunpeng_zlib_${accelerator_version}.patch >> $output_path
                ./configure --prefix=${zlib_install_path} >> $output_path
                make clean >> $output_path
                make >> $output_path
                make install >> $output_path
                mv /lib64/libz.so.1 /lib64/libz.so.bak
                ln -s ${zlib_install_path}/lib/libz.so.${elseos_zlib_version} /lib64/libz.so.1
            else
                log "zlib src not exist ${LINENO}" error
            fi
        else
            log "tar -zxvf ${zlib_patch}-${accelerator_version}.tar.gz failed" error
            return 1
        fi
    else
        log "${zlib_patch}-${accelerator_version}.tar.gz not exist" error
        return 1
    fi 

    if [ `ldd /lib64/libz.so.1 | grep libwd.so.1 | wc -l` -eq 0 ]; then
        log "zlib patch failed" error
        return 1
    fi

    log "zlib patch success" warn
    return 0
}

install_accelerator()
{
    #检查license
    license=`lspci | grep ZIP | wc -l`
    if [ $license -eq 0 ]; then
        log "install_accelerator no license ${LINENO}" error
        return 1
    fi

    #检查加速器是否已经安装
    accelerator_installed_flag=1
    for modname in ${install_koname[*]}
    do
        if [ `lsmod | grep uacce | grep $modname | wc -l` -eq 0 ]; then
            accelerator_installed_flag=0
            break
        fi
    done

    if [ $accelerator_installed_flag -eq 0 ]; then
        #选择驱动安装方式
        cd $package_path
        if [ `ls | grep ${accelerator_version}.*rpm | grep ${accelerator_os} | wc -l` -eq ${rpm_totalnum} ]; then
            ##os对应rpm包存在则选择rpm_install
            rpm_install
            [[ $? -ne 0 ]] && log "install_accelerator:rpm install failed! ${LINENO}" error && return 1
        elif [ `ls | grep ${accelerator_version}.*tar.gz | wc -l` -eq ${src_totalnum} ]; then
            ##只有src则选择src_install
            src_install
            [[ $? -ne 0 ]] && log "install_accelerator:src install failed! ${LINENO}" error && return 1
        else
            log "not found rpm/src ${LINENO}" error
            return 1
        fi
        cd $SCRIPT_HOME
    fi

    #zlib库打patch
    cd $package_path
    zlib_patch
    [[ $? -ne 0 ]] && log "install_accelerator:zlib patch failed! ${LINENO}" error && return 1

    log "install_accelerator successed!" warn
    return 0
}

uninstall_accelerator()
{
    #检查加速器是否已经安装
    accelerator_uninstalled_flag=1
    for modname in ${install_koname[*]}
    do
        if [ `lsmod | grep uacce | grep $modname | wc -l` -ne 0 ]; then
            accelerator_uninstalled_flag=0
            break
        fi
    done
    #还原libz.so
    if [ `ldd /lib64/libz.so.1 | grep libwd.so.1 | wc -l` -ne 0 ]; then
        if [ -e /lib64/libz.so.bak ]; then
            rm -f /lib64/libz.so.1
            mv /lib64/libz.so.bak /lib64/libz.so.1
        else
            log "not found libz.so.bak, you need to manually ln -s libz.so.1" error
            return 1
        fi
    fi

    if [ $accelerator_uninstalled_flag -eq 0 ]; then
        ##源码安装文件存在则源码卸载，否则rpm卸载
        if [ -e $package_path/${driver_src} ]; then
            cd $package_path/${driver_src}
            for dirname in ${driver_dirname[*]}
            do
                cd $package_path/${driver_src}/$dirname
                make uninstall
            done
        elif [ `rpm -qa | grep ${install_koname[-1]} | wc -l` -ne 0 ]; then
            konum=`expr ${#install_koname[*]} - 1`
            for i in `seq $konum -1 0`
            do
                rpm -e ${install_koname[i]}
            done
            for rpm_name in ${install_soname[*]}
            do
                rpm -e ${rpm_name}
            done
        else
            log "uninstall not found rpm/src" error
            #return 1
        fi
        ##移除mod
        #mod_num=`lsmod |grep uacce|awk '{print $4}'|awk -F"," '{print NF}'`
        for modname in ${uninstall_koname[*]}
        do
            #modname=`lsmod |grep uacce|awk '{print $4}'|awk -F"," '{print $1}'`
            rmmod $modname
        done
    fi
    #卸载zlib
    if [ `ls -l /lib64/libz.so.1 | grep ${centos7_zlib_version} | wc -l` -ne 0 ]; then
        cd $package_path/$zlib_patch/zlib-$centos7_zlib_version
        make uninstall
    elif [ `ls -l /lib64/libz.so.1 | grep ${elseos_zlib_version} | wc -l` -ne 0 ]; then
        cd $package_path/$zlib_patch/zlib-$elseos_zlib_version
        make uninstall
    else
        log "zlib uninstall not found src" error
        return 1
    fi

    if [ `lsmod | grep uacce | wc -l` -ne 0 ]; then
        log "uninstall_accelerator failed" error 
        return 1
    fi

    log "uninstall_accelerator successed!" warn
    return 0
}

if [ $# -lt 1 ]; then
    log "Usage: $0 <install|uninstall> [package-path] " error
    exit 1
fi
if [ $1 != "install" ] && [ $1 != "uninstall" ]; then
    log "Usage: $0 <install|uninstall> [package-path] " error
    exit 1
fi
if [ $# -ge 2 ]; then
        package_path=$2
else
        package_path=$SCRIPT_HOME
fi

${1}_accelerator
exit $?