#!/bin/bash
setIP() {
  fileName=/etc/sysconfig/network-scripts/ifcfg-$1
  bak_file="/etc/sysconfig/network-scripts/bak-${1}"
  if [[ -f $fileName ]]; then
    cp $fileName $bak_file
    cat ${fileName} | grep IPADDR &>/dev/null
    if [[ $? -ne 1 ]]; then
      sed -i "s/IPADDR.*/IPADDR=${2}/g" $fileName
    else
      echo "IPADDR=${2}" >>$fileName
    fi
    cat ${fileName} | grep NETMASK &>/dev/null
    if [[ $? -ne 1 ]]; then
      sed -i "s/NETMASK.*/NETMASK=${3}/g" $fileName
    else
      echo "NETMASK=${3}" >>$fileName
    fi
    #            cat ${fileName} | grep GATEWAY &> /dev/null
    #            if [[ $? -ne 1 ]]; then
    #                sed -i "s/GATEWAY.*/GATEWAY=${4}/g" $fileName
    #            else
    #                echo "GATEWAY=${4}" >> $fileName
    #            fi
    cat ${fileName} | grep BOOTPROTO &>/dev/null
    if [[ $? -ne 1 ]]; then
      sed -i "s/BOOTPROTO.*/BOOTPROTO=static/g" $fileName
    else
      echo "BOOTPROTO=${4}" >>$fileName
    fi
    cat ${fileName} | grep ONBOOT &>/dev/null
    if [[ $? -ne 1 ]]; then
      sed -i "s/ONBOOT.*/ONBOOT=yes/g" $fileName
    else
      echo "ONBOOT=yes" >>$fileName
    fi

    cat ${fileName} | grep MTU &>/dev/null
    if [[ $? -ne 1 ]]; then
      sed -i "s/MTU.*/MTU=9000/g" $fileName
    else
      echo "MTU=9000" >>$fileName
    fi
  else
    ifconfig ${1} ${2}/24
    cat >>$fileName <<EOF
TYPE=Ethernet
PROXY_METHOD=none
BROWSER_ONLY=no
BOOTPROTO=static
DEFROUTE=yes
IPV4_FAILURE_FATAL=no
IPV6INIT=yes
IPV6_AUTOCONF=yes
IPV6_DEFROUTE=yes
IPV6_FAILURE_FATAL=no
IPV6_ADDR_GEN_MODE=stable-privacy
NAME=$1
DEVICE=$1
ONBOOT=yes
IPADDR=$2
NETMASK=$3
IPV6_PRIVACY=no
MTU=9000
EOF
  fi
}

exec_setip() {
  log "start config public IP address" info
  if [ ${#public_ip[*]} -gt 0 ]; then
    for ((i = 0; i < ${#public_ip[*]}; i++)); do
      setIP ${public_ethlist[$i]} ${public_ip[$i]} $public_mask $public_gateway
    done
  else
    log "Please check the ${SCRIPT_HOME}/.cfg pub_enthlist" info
  fi

  log "start config cluster IP address" info
  if [ ${#cluster_ip[*]} -gt 0 ]; then
    for ((i = 0; i < ${#cluster_ip[*]}; i++)); do
      setIP ${cluster_ethlist[$i]} ${cluster_ip[$i]} $cluster_mask $cluster_gateway
    done
  else
    log "Please check the ${SCRIPT_HOME}/setting.cfg clu_enthlist" info
  fi

  systemctl restart network
  if [ $? -eq 0 ]; then
    log "config IP successful" info
    return 0
  else
    log "config IP faild please check network log" error
    return 1
  fi
}
