#!/bin/bash

setHostname() {
  log "start config hostname info " info
  hostnamectl --static set-hostname ${hostname}
  log "Set-hostname $hostname successful" info

  server_count=${#server[@]}
  client_count=${#client[@]}

  # config /etc/hosts
  for ((i = 0; i < $server_count; i++)); do
    cat /etc/hosts | grep ${servername[i]} > /dev/null
    if [ $? -eq 1 ]; then
      echo "${server[i]} ${servername[i]}" >>/etc/hosts
    else
      sed -i "s/.*${servername[i]}/${server[i]} ${servername[i]}/g" /etc/hosts
    fi
  done

  for ((i = 0; i < $client_count; i++)); do
    cat /etc/hosts | grep ${clientname[i]} > /dev/null
    if [ $? -eq 1 ]; then
      echo "${client[i]} ${clientname[i]}" >>/etc/hosts
    else
      sed -i "s/.*${clientname[i]}/${client[i]} ${clientname[i]}/g" /etc/hosts
    fi
  done
  return 0
}
