#!/bin/bash


exec_pbrouting(){
  count=0
  for ((i=0; i<${#public_ethlist[*]}; i++))
  do
	  	#建立路由表
        echo "20${count} p${count}" >> /etc/iproute2/rt_tables  
        log "rt_tables: `cat /etc/iproute2/rt_tables`" info
		#添加路由策略到路由表
        ip route add ${public_net} dev ${public_ethlist[${i}]} src ${public_ip[${count}]} table p${count}  
        ip rule add from ${public_ip[${count}]} table p${count}
        ip rule add dev ${public_ethlist[${i}]} table p${count}
		#删除原main表中的路由
        route del -net ${public_net} gw 0.0.0.0 dev ${public_ethlist[${i}]}
		#每个路由表中为对应设备添加默认路由，实现ip互通
        ip route add ${public_net} dev ${public_ethlist[${i}]} proto kernel scope link src ${public_ip[${count}]} metric 100 table p${count}
        log "table 20${count}: `ip route show table 20${count}`" log
        let count=count+1
  done

  count=0
  for ((i=0; i<${#cluster_ethlist[*]}; i++))
  do
		#建立路由表
        echo "21${count} c${count}" >> /etc/iproute2/rt_tables  
        log "rt_tables: `cat /etc/iproute2/rt_tables`" log
		#添加路由策略到路由表
        ip route add ${cluster_net} dev ${cluster_ethlist[${i}]} src ${cluster_ip[${count}]} table c${count}  
        ip rule add from ${cluster_ip[${count}]} table c${count}
        ip rule add dev ${cluster_ethlist[${i}]} table c${count}
		#删除原main表中的路由
        route del -net ${cluster_net} gw 0.0.0.0 dev ${cluster_ethlist[${i}]}
		#每个路由表中为对应设备添加默认路由，实现ip互通
        ip route add ${cluster_net} dev ${cluster_ethlist[${i}]} proto kernel scope link src ${cluster_ip[${count}]} metric 100 table c${count}
        log "table 21${count}: `ip route show table 21${count}`" log
        let count=count+1
  done

  #为mon_ip在main表中添加路由
  ip route add ${public_net} dev ${public_ethlist[0]} proto kernel scope link src ${public_ip[0]} metric 100 table main
  log "`route -n`" log
}
