declare -A rotationalMap
declare -A sizeMap
walDevice=""

GetSystemDiskInfo()
{
    local diskList=$(lsblk -d -o name,rota,size | awk '{if(NR>1) print $1}')
    local rotationalList=$(lsblk -d -o name,rota,size | awk '{if(NR>1) print $2}')
    local sizeList=$(lsblk -d -o name,rota,size | awk '{if(NR>1) print $3}')

    diskList=(${diskList// /})
    rotationalList=(${rotationalList// /})
    sizeList=(${sizeList// /})

    local num=${#diskList[@]}
    
    if (( $num == 0 ))
    then
        log "diskList error" error
        return 1
    fi

    for((i=0; i<$num;i++))
    do
        key=${diskList[$i]}
        value=${rotationalList[$i]}
        sizeV=${sizeList[$i]}
        rotationalMap[$key]=$value
        sizeMap[$key]=$sizeV
    done

}

GetDiskSizeInGUnit()
{
    local realDiskSize=$1
    local diskUnit=${realDiskSize:0-1}
    realDiskSize=${realDiskSize%$diskUnit}

    if [ "$diskUnit" == "T" ]
    then
        outSize=$(echo "scale=0;$realDiskSize*1024"|bc)
        outSize=$(echo $outSize | awk '{print int($0)}' )
    elif [ "$diskUnit" == "G" ]
    then
        outSize=$( echo $realDiskSize | awk '{print int($0)}' )
    else
        log "Disk unit is $diskUnit which is too small to use" error
        return 1
    fi
    globalDiskSize=$outSize
    return 0
}


CheckRawDiskSize()
{
    local diskSize=$1
    local diskSizeNeeded=$2
   
    GetDiskSizeInGUnit $diskSize 
    ret=$?
    if [ "0" -ne $ret ]
    then
        return 1
    fi
    
    local realDiskSize=$globalDiskSize
    if (( diskSizeNeeded == realDiskSize ))
    then
        return 0
    else
        log "The disk size $diskSizeNeeded, is not equle to $realDiskSize" error
        return 1
    fi
}

CheckWalDbDiskSize()
{
    local diskDevList=($1)
    local totalDevSize=0

    for dev in ${diskDevList[@]}
    do
        GetDiskSizeInGUnit ${sizeMap[$dev]}
        ret=$?
        if [ "0" -ne $ret ]
        then
            return 1
        fi
        local realDiskSize=$globalDiskSize
        totalDevSize=`expr $totalDevSize + $realDiskSize`
    done
    local totalDb=`expr $dbSize \* $osdNum`
    local totalWal=`expr $walSize \* $osdNum`
    local dbWalNeededSize=`expr $totalDb + $totalWal`
    if (( dbWalNeededSize  > totalDevSize ))
    then
        log "The needed disk size is $dbWalNeededSize, but only $totalDevSize afford" error
        return 1
    else
        return 0
    fi
    

}

CheckDiskExistAndType()
{
    local diskDevList=($1)
    local len=${#diskDevList[@]}
    local sum=0

    for dev in ${diskDevList[@]}
    do
        #check if disk is existed
        if [ ! -n "${rotationalMap[$dev]}" ]
        then
            log "Disk $dev is not existed in this system" error
            return 1
        else
            sum=$[sum + rotationalMap[$dev]]
        fi
    done

    if (( $sum == $len ))  || (( $sum == 0 ))
    then
        log "Success" info
    else
        log "Not all disk type are the same" error
        return 1
    fi
    return 0
}

CheckDiskSizeInArray()
{
    local diskDevList=($1)
    local diskSize=0
    local count=0
    
    for dev in ${diskDevList[@]}
    do
        if [ "0" -ne $count ]
        then 
            CheckRawDiskSize ${sizeMap[$dev]} $diskSize
            ret=$?
            if [ "0" -ne $ret ]
            then
                log "Check size of $dev failed, not equal to $diskSize" error
                return 1
            fi
        else
            GetDiskSizeInGUnit ${sizeMap[$dev]}
    	    ret=$?
            if [ "0" -ne $ret ]
            then
                return 1
            fi
            diskSize=$globalDiskSize
        fi
        count=`expr $count + 1 `    
    done
    return 0
}




CheckDbWalDiskInfo()
{
    local diskDevList=($1)

    CheckDiskExistAndType "${diskDevList[*]}"
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Check disk exist and disk type failed" error
        return 1
    fi

    CheckWalDbDiskSize "${diskDevList[*]}"
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Check wal db disk size failed" error
        return 1
    fi

   return 0
}


CheckDataDiskInfo()
{
    local diskDevList=($1)
    #local diskSize=$2

    CheckDiskExistAndType "${diskDevList[*]}"
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Check disk exist and disk type failed" error
        return 1
    fi

    CheckDiskSizeInArray "${diskDevList[*]}" 
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Check disk size failed" error
        return 1
    fi

    return 0
}


CheckVgExisted()
{
    local vgNum=$(vgs | grep ceph | wc -l)
    if [ "0" -ne $vgNum ]
    then
        log "ceph vg existed, please clean it first" error
        return 1
    fi
    return 0
}

DiskParaCheck()
{
    osdNum=${#dataDevList[@]}
    osdNum=$(echo "$osdNum*$osd_per_dev"|bc)

    GetSystemDiskInfo
    #校验data盘的合法性,盘是否存在，盘的大小是不是都一致    
    CheckDataDiskInfo "${dataDevList[*]}" 
    local ret=$?
    if [ 0 -ne  $ret ]
    then
        log "Check data dev list failed" error
        return 1
    fi

    #校验db 和wal 盘的合法性
    if  [ $dbSize -ne 0 ]  || [ $walSize -ne 0 ]
    then
        echo BeginOfCheckDbWalDisk
        CheckDbWalDiskInfo "${dbwalDevList[*]}" 
        ret=$?
        if [ "0" -ne $ret ]
        then
            log "Check dbwal dev list failed" error
            return 1
        fi
    fi
    
    #校验是否已经创建了vg
    CheckVgExisted
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Check vg env failed" error
        return 1
    fi      
    return 0            
}

#dataDevList=($1)
##dataDevSize=$2
#dbwalDevList=($2)
#dbSize=$3
#walSize=$4
#osd_per_dev=$5

globalDiskSize=0
#for i in ${dataDevList[*]}; 
#do
#    echo $i
#done

#DiskParaCheck
