walDevice=""


CreateDataOsd()
{
    log 'Begin to create data lv' info
    local dataDiskDevList=($1)
    datavgcount=0
    datalvcount=0

    for dataDev in ${dataDiskDevList[@]}
    do
        vgcreate --yes -s 1G ceph-data${datavgcount}  /dev/$dataDev
        local ret=$?
        
        if (( $ret != 0 ))
        then
            log "Create vg /dev/${dataDev} failed " error
            return 1
        fi 

        local dataDiskSize=0
        dataDiskSize=$(vgdisplay  ceph-data${datavgcount} | grep "Total PE" | awk '{print $3}')
        osdSize=$(echo "scale=0;${dataDiskSize}/${osd_per_dev}"|bc -l)
        
        for (( curCount=1; curCount <= osd_per_dev;curCount++))
        do
            lvcreate -y -l $osdSize -n osd-data${datalvcount} ceph-data${datavgcount}
            ret=$?
            if (($ret != 0))
            then
                log "Create lv osd-data${count} failed " error
                return 1
            fi
            datalvcount=$[datalvcount + 1]
        done   
        
        datavgcount=$[datavgcount + 1]
    done
}



CheckDbWalDiskSize()
{
    local osdList=($1)
    local waldbDevList=($2)
    local waldbDiskNum=${#waldbDevList[@]}
	
    osdNum=${#osdList[@]}
    osdNum=$(echo "$osdNum*$osd_per_dev"|bc)

    local waldbVgSize=$(vgdisplay ceph-wal-db | grep "Total PE" | awk '{print $3}')
    local totalDb=`expr $dbSize \* $osdNum`
    local totalWal=`expr $walSize \* $osdNum`
    local dbWalNeededSize=`expr $totalDb + $totalWal`
    
    if (( dbWalNeededSize  > waldbVgSize ))
    then
        log "The needed disk size is $dbWalNeededSize, but only $waldbVgSize afford" error
        return 1
    else
        return 0
    fi
}


GetDbWalDevInfo()
{
    local walList=($1)
    local len=${#walList[@]}

    for walDev in ${walList[@]}
    do
        local device=" /dev/"${walDev}
        walDevice="${walDevice} ${device}"
        
    done
}

CreateWalDbVg()
{
    vgcreate --yes -s 1G ceph-wal-db $walDevice
    ret=$?
    if (($ret != 0))
    then
        log "Create wal db vg failed " error
        return 1
    fi
}

CreateLv()
{
    for (( curNum=0; curNum < osdNum; curNum++))
    do
        if (( $walSize != 0 ))
        then
            lvcreate -y  -l $walSize -n wal-data${curNum} ceph-wal-db
        fi

        if (( $dbSize != 0))
        then
            lvcreate -y -l $dbSize -n db-data${curNum} ceph-wal-db
        fi
    done    
}

CreateDbWalDisk()
{
    log 'Begin to create db wal lv' info
    local dataDevArray=($1)
    local dbwalDevArray=($2)
    #local createSize=$3

    GetDbWalDevInfo "${dbwalDevArray[*]}"
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Get db wal dev info failed" error
        return 1
    fi
    
    CreateWalDbVg
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Create wal db vg failed" error
        return 1
    fi
    
    CheckDbWalDiskSize "${dataDevArray[*]}" "${dbwalDevArray[*]}" 
    local ret=$?
    if [ "0" -ne $ret ]
    then
        log "Check db wal disk size failed" error
        return 1
    fi


    CreateLv 
    ret=$?
    if [ "0" -ne $ret ]
    then
         log "Create db wal lv failed" error
         return 1
    fi
    return 0

}


CreateOsdLv()
{

    CreateDataOsd "${dataDevList[*]}" 
    ret=$?
    if [ "0" -ne $ret ]
    then
        log "Create data lv failed" error
        return 1
    fi    

    if  [ $dbSize -ne 0 ]  || [ $walSize -ne 0 ]
    then
        CreateDbWalDisk "${dataDevList[*]}" "${dbwalDevList[*]}" 
        ret=$?
        if [ "0" -ne $ret ]
        then
            log "Create db wal lv failed" error
            return 1
        fi
    fi    

    return 0            
}

#dataDevList=($1)
#dataDevSize=$2
#dbwalDevList=($2)
#dbwalDevSize=$4
#dbSize=$3
#walSize=$4
#osd_per_dev=$5

#CreateOsdLv

