#!/bin/bash
#
# local ceph env_prepare scripte
#
# input type arg
# @parm1: hostname   ceph1/ceph2/client1/client2
# @parm2: nopassword_config flag   0/1
#

SCRIPT_HOME=$(
  cd $(dirname $0)/
  pwd
)
source $SCRIPT_HOME/env.cfg
source $SCRIPT_HOME/../conf/common.cfg
source $SCRIPT_HOME/../common/common.sh
source $SCRIPT_HOME/closeFirewall.sh
source $SCRIPT_HOME/closeSelinux.sh
source $SCRIPT_HOME/configBond.sh
source $SCRIPT_HOME/configNoPasswd.sh
source $SCRIPT_HOME/configNtp.sh
source $SCRIPT_HOME/installCeph.sh
source $SCRIPT_HOME/setHostname.sh
source $SCRIPT_HOME/setIp.sh
source $SCRIPT_HOME/policyBasedRouting.sh
source $SCRIPT_HOME/osd_create_new.sh
source $SCRIPT_HOME/addProfile.sh

source $SCRIPT_HOME/../conf/${1}
LOG_FILE=/var/log/ceph_local_install.log

log "@@@ start install on ${1}@@@" debug
log "### start online Install###" debug
onlineInstall
[[ $? -ne 0 ]] && log "onlineInstall failed  ${LINENO}" error && exit 1
log "### end online Install###" debug

log "###start config firewall###" debug
closeFirewall
[[ $? -ne 0 ]] && log "closeFirewall failed  ${LINENO}" error && exit 1
log "###end config firewall###" debug

log "###start config selinux###" debug
closeSelinux
[[ $? -ne 0 ]] && log "closeSelinux failed ${LINENO}" error && exit 1
log "###end config selinux###" debug

log "###start config hostname###" debug
setHostname
[[ $? -ne 0 ]] && log "setHostname failed  ${LINENO}" error && exit 1
log "###end config hostname###" debug

if [ $2 -eq 0 ]; then
  log "###start config nopasswd###" debug
  configManagerNoPasswd
  [[ $? -ne 0 ]] && log "configNoPasswd failed  ${LINENO}" error && exit 1
  log "###end config nopasswd###" debug
fi

log "###start config bond###" debug
exec_configbond
[[ $? -ne 0 ]] && log "exec_configbond failed  ${LINENO}" error && exit 1
log "###end config bond###" debug

log "###start set ip###" debug
exec_setip
[[ $? -ne 0 ]] && log "exec_setip failed  ${LINENO}" error && exit 1
log "###end set ip###" debug

if [[ $all_node_ssd -eq 1 ]];then
  log "###start set policy-based routing###" debug
  exec_pbrouting
  [[ $? -ne 0 ]] && log "exec_pbrouting failed  ${LINENO}" error && exit 1
  log "###end set policy-based routing###" debug
fi

log "###start config ntp###" debug
configNtp
[[ $? -ne 0 ]] && log "configNtp failed  ${LINENO}" error && exit 1
log "###end config ntp###" debug

if [[ $dataDevList ]]; then
  log "###start create lv###" debug
  CreateOsdLv
  [[ $? -ne 0 ]] && log "create lv failed  ${LINENO}" error && exit 1
  log "###end create lv###" debug
fi

log "@@@install on ${1} success@@@" debug
exit 0
