#!/bin/bahs

installCeph()
{
    if [ $install_type == "yum" ];then
        #配置epel安装源
        yum -y install epel-release
        #配置ceph安装源
        ceph_repo=/etc/yum.repos.d/ceph.repo
        cat >$ceph_repo<<EOF
[Ceph]
name=Ceph packages for \$basearch
baseurl=http://download.ceph.com/rpm-nautilus/el7/\$basearch
enabled=1
gpgcheck=1
type=rpm-md
gpgkey=https://download.ceph.com/keys/release.asc
priority=1

[Ceph-noarch]
name=Ceph noarch packages
baseurl=http://download.ceph.com/rpm-nautilus/el7/noarch
enabled=1
gpgcheck=1
type=rpm-md
gpgkey=https://download.ceph.com/keys/release.asc
priority=1

[ceph-source]
name=Ceph source packages
baseurl=http://download.ceph.com/rpm-nautilus/el7/SRPMS
enabled=1
gpgcheck=1
type=rpm-md
gpgkey=https://download.ceph.com/keys/release.asc
priority=1
EOF
        #更新yum源
        yum clean all && yum makecache
        yum -y install ceph ceph-radosgw
        if [ $hostname == ${server[0]} ];then
            yum -y install ceph-deploy
        fi
        
	ceph -v
	if [ $? -eq 0 ];then
	    echo "install ceph successful"
	    return 0
	else
            echo "install ceph failed"
	    return 1
	fi
    elif [ $install_type == "local" ];then
	ceph_file=$ceph_path
        deploy_file=$(find $ceph_deploy_path -name 'ceph-deploy-2.0.1-0.noarch.rpm')
        echo "Installing,please wait......"
	echo $ceph_file
	echo $deploy_file
        #rpm -Uvh $ceph_file*.rpm #&> /dev/null
	yum -y install $ceph_file*.rpm
        if [ $? -eq 0 ];then
	    #echo "install ceph_14.2.1 successful"
	    if [ $hostname == ${server[0]} ];then
                if [ -f $deploy_file ];then
                    rpm -ivh $deploy_file &> /dev/null
                    echo "install ceph-deploy successful"
                else
                    echo "No such file or direcory"
                fi
            fi

	    ceph -v
            if [ $? -eq 0 ];then
                echo "install ceph_14.2.1 successful"
		return 0
            else
                echo "install ceph_14.2.1 failed"
                return 1
	    fi

        else
	    echo "install ceph_14.2.1 failed"
	    return 1
	fi
    else
	    echo 'Please check the install_type.'
	    return 1
    fi
}

