#!/bin/bash

configNtp() {
  log "start config ntp" info
  if [ ! -f /etc/ntp.conf ]; then
    log "please install NTP" error
    exit 1
  fi
  if [ ! -f /etc/ntp.conf.bak ]; then
    cd /etc && mv ntp.conf ntp.conf.bak
  else
    rm -rf ntp.conf
  fi
  ip add show | grep ${ntp_server}
  if [ $? -eq 0 ]; then
    echo "restrict 127.0.0.1" >/etc/ntp.conf
    echo "restrict ::1" >>/etc/ntp.conf
    echo "restrict $public_gateway mask $public_mask" >>/etc/ntp.conf
    echo "server 127.127.1.0" >>/etc/ntp.conf
    echo "fadge 127.127.1.0 stratum 8" >>/etc/ntp.conf
    systemctl enable ntpd
    systemctl start ntpd
    ntpStatus=$(systemctl status ntpd | sed -n "3p" | awk -F" " '{print $2 $3}')
    if [ $ntpStatus == "active(running)" ]; then
      log "ntp server active" info && return 0
    else
      log "ntp server inactive" error && return 1
    fi
  else
    cat /etc/ntp.conf | grep server &>/dev/null
    if [ $? -eq 0 ]; then
      sed -i "s/^server/#&/" /etc/ntp.conf
      echo "server $ntp_server" >>/etc/ntp.conf
      ntpdate $ntp_server > /dev/null
    else
      echo "server $ntp_server" >>/etc/ntp.conf
      ntpdate $ntp_server > /dev/null
    fi
    if [ $? -eq 0 ]; then
      #echo "The NTP socket is in use,exiting"
      hwclock -w
    else
      log "ntpdate failed you need check ntpserver" error
    fi
    chkconfig crond on
    [[ $? -ne 0 ]] && log "chkconfig crond on failed  ${LINENO}" error && retrrn 1
    systemctl start crond
    [[ $? -ne 0 ]] && log "start crond failed  ${LINENO}" error && retrrn 1
    (crontab -l 2>/dev/null; echo "*/10 * * * * /usr/sbin/ntpdate $ntp_server") | crontab -
    [[ $? -ne 0 ]] && log "add crond task failed  ${LINENO}" error && retrrn 1
    return 0
  fi
}
