#!/bin/bash

configBond() {
  #生成bond配置文件
  log "start config bond $1" info
  if [ $# -le 1 ]; then
    log "pleace check the bond_info,ask it's not empty" error
    exit 1
  fi
  bond_file=/etc/sysconfig/network-scripts/ifcfg-$1
  cat >$bond_file <<EOF
DEVICE=$1
Type=Bond
BONDING_MASTER=yes
BOOTPROTO=none
ONBOOT=yes
BONDING_OPTS="mode=4 miimon=100"
MTU=9000
EOF

  #ifcfg-***文件增加bond
  nic_counts=$#
  for ((i = 2; i <= $nic_counts; i++)); do
    nic_file=/etc/sysconfig/network-scripts/ifcfg-$(eval echo '$'"$i")
    #echo $nic_file
    cat >$nic_file <<EOF
TYPE=Ethernet
BOOTPROTO=none
IPV6INIT=no
DEVICE=$(eval echo '$'"$i")
ONBOOT=yes
MASTER=$1
SLAVE=yes
EOF
  done
  #systemctl restart network
  if [ $? -eq 0 ]; then
    log "config IP:${1} successful" info
    return 0
  else
    log "config IP:${1} faild" error
    return 1
  fi
}

exec_configbond() {
  #get all bond info
  log "start exec config bond " info
  if [ ${#bond[@]} -ne 0 ]; then
    for bondinfo in "${bond[@]}"; do
      bond_info=($bondinfo)
      configBond ${bond_info[*]}
    done
  else
    log "no need config bond" info
  fi
}
