#!/bin/bash

closeFirewall() {
  if [[ $firewall -eq 0 ]]
  then
    systemctl restart firewalld
    systemctl stop firewalld && systemctl disable firewalld
    firewallStatus=$(systemctl status firewalld | tail -1 | awk -F" " '{print $6}')
    if [ $firewallStatus == Stopped ]; then
      log "close firewall successful" info
      return 0
    else
      log "close firewall failed" error
      return 1
    fi
  else
    firewall-cmd --zone=public --add-port=123/udp --permanent
    firewall-cmd --reload
    log "Open udp port 123" info
  fi
}

