#!/bin/bash
#
# local ceph env_prepare scripte
#
# input type arg
# @parm1: hostname   ceph1/ceph2/client1/client2
# @parm2: nopassword_config flag   0/1
#

SCRIPT_HOME=$(
  cd $(dirname $0)/
  pwd
)
source $SCRIPT_HOME/../conf/common.cfg
source $SCRIPT_HOME/../conf/manual.cfg
source $SCRIPT_HOME/../common/common.sh
source $SCRIPT_HOME/../env_ready/addProfile.sh
source $SCRIPT_HOME/../env_ready/osd_para_check.sh

source $SCRIPT_HOME/../conf/${1}
LOG_FILE=/var/log/ceph_local_install.log

rm -rf $LOG_FILE
log "@@@@start check host ${1}@@@" debug
log "###start set proxy ###" debug
setProxy
[[ $? -ne 0 ]] && log "setProxy failed ${LINENO}" error && exit 1
log "###end set proxy ###" debug

log "###start set yum conf###" debug
setYumConf
[[ $? -ne 0 ]] && log "setProxy failed ${LINENO}" error && exit 1
log "###end set yum conf###" debug

if [[ $dataDevList ]]; then
  log "###start check disk###" debug
  DiskParaCheck
  [[ $? -ne 0 ]] && log "check disk failed ${LINENO}" error && exit 1
  log "###end check disk###" debug
fi
log "@@@@end check host ${1}@@@" debug
exit 0