#!/bin/bash

function setProxy(){
   log "start set set proxy" info
   if [[ $config_proxy ]]
   then
     export http_proxy=$config_proxy
     export https_proxy=$config_proxy
     export no_proxy=$config_no_proxy
     cat /etc/environment | grep exclude &>/dev/null
     if [[ $? -ne 1 ]]; then
       sed -i "s/http_proxy=.*/http_proxy=$config_proxy/g" /etc/environment
       sed -i "s/https_proxy=.*/https_proxy=$config_proxy/g" /etc/environment
       sed -i "s/no_proxy=.*/no_proxy=$config_no_proxy/g" /etc/environment
     else
       echo export http_proxy=$config_proxy  >> /etc/environment
       echo export https_proxy=$config_proxy  >> /etc/environment
       echo export no_proxy=$config_no_proxy >> /etc/environment
     fi
  fi
}

function setYumConf() {
  log "start set yum config" info
   if [[ $yum_exclude ]]
   then
     cat /etc/yum.conf | grep exclude &>/dev/null
     if [[ $? -ne 1 ]]; then
       sed -i "s/exclude.*/exclude=$yum_exclude/g" /etc/yum.conf
     else
       echo "exclude=$yum_exclude" >> /etc/yum.conf
     fi
   fi
}

function onlineInstall() {
  log "start install packages" info
  yum -y install epel-release > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1

  yum clean all > /dev/null 2>&1;yum makecache > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1

  yum -y install ntp ntpdate python-pip dos2unix net-tools expect crontabs yum-plugin-priorities bc > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1

  pip install --upgrade pip > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1
  return 0
}

function script_config() {
  log "start set script config" info
  find $SCRIPT_HOME -type f -print0 | xargs -0 dos2unix -- >/dev/null 2>&1
  return 0
}

function offlineInstall() {
  log "start offline package install" info
  for i in autogen-libopts ntpdate ntp-4.2.6; do
    file=$(find $ntp_path | grep $i)
    if [ -f $file ]; then
      rpm -ivh $file
    else
      log "Error:Missing dependency package." error
    fi
  done
  rpm -qa | grep ntp-4.2.6
  if [ $? -eq 0 ]; then
    log "Install ntp successful." info
    return 0
  else
    log "Install ntp failed." error
    return 1
  fi
}
