log()
{
    if [ $# -eq 2 ]; then
        log_level=$2
    else
        log_level="error"
    fi
    if [[ $log_level = "info" || $log_level = "INFO" ]];then
      echo "`date "+%Y-%m-%d %T"` $log_level: $1" >> ${LOG_FILE}
    else
      echo "`date "+%Y-%m-%d %T"` $log_level: $1" | tee -a ${LOG_FILE}
    fi
}

check_client_number()
{
    check_num=$1
    num=${#client[*]}
    echo $check_num $num $client
    if [ $check_num -gt $num ]; then
        log "client number is not valid" error && return 1
    fi
    return 0
}

check_server_number()
{
    check_num=$1
    num=${#server[*]}
    if [ $check_num -gt $num ]; then
        log "server number is not valid" error && return 1
    fi
    return 0
}

check_block_size()
{
    check_num=$1
    num=${#block_size[*]}
    if [ $check_num -gt $num ]; then
        log "block size is not valid export $check_num" error && return 1
    fi
    return 0
}

check_rw_opt()
{
    check_num=$1
    num=${#operator[*]}
    if [ $check_num -gt $num ]; then
        log "operator type is not valid export $operator" error && return 1
    fi
    return 0
}

copy_remote_file()
{
    if [ $# -gt 2 ]; then
        node_ip=$3
        log "scp -r $1 ${remote_user}@${node_ip}:$2" info
        scp -r $1 ${remote_user}@${node_ip}:$2 > /dev/null
        [[ $? -ne 0 ]] && log "scp $src_file to $dst_path failed! line: ${LINENO}" error && return 1
    else
        for node_ip in ${client[*]}
        do
            scp -r $1 ${remote_user}@${node_ip}:$2 > /dev/null
            [[ $? -ne 0 ]] && log "scp $src_file to $dst_path failed! line: ${LINENO}" error && return 1
        done
    fi
    return 0
}

exec_remote_client()
{
    rets=$(ssh ${remote_user}@$1 "$2")
    #[[ $? -ne 0 ]] && log "ERR: exec remote cmd $2 res $rets failed! line: ${LINENO}" && return 1
    #return 0
    if [ $? -eq 0 ];then
      log "Execute $2: ${rets}" info
      return 0
    else
      log "Execute $2: ${rets}" error
	    return 1
    fi
}

exec_remote_withresult()
{
    res=$(ssh ${remote_user}@$1 "$2")
    echo $res
}

check_nmon_installed()
{
    exec_remote_client $1 "rpm -qa | grep nmon"
    [[ $? -ne 0 ]] && log "nmon not installed" error && return 1
    return 0
}

check_server_type()
{
    exec_remote_client $1 "rpm -qa | grep x86_64"
    [[ $? -ne 0 ]]  && return 1
    return 0
}

nmon_monitor_start()
{
    #check nmon installed in server host
    check_nmon_installed $1
    if [[ $? -ne 0 ]]; then
        exec_remote_client $1 "yum install -y nmon"
    fi
    exec_remote_client $1 "rm -rf ${log_path};mkdir -p ${log_path}"
    exec_remote_client $1 "nmon -s 2 -f -m ${log_path}"
    [[ $? -ne 0 ]] && log "nmon start failed ${LINENO}" error && return 1
    return 0
}

ceph_monitor_start()
{
    exec_remote_client $1 "top -b -u ceph -d 2 >> ${log_path}/top.txt&"
    return $?
}

nmon_monitor_stop()
{
    #check nmon installed in server host
    exec_remote_client $1 "ps -ef | grep 'nmon -s' | grep -v 'grep' | awk '{print \$2}' | xargs kill -9"
    return 0
}

ceph_monitor_stop()
{
    exec_remote_client $1 "ps -ef | grep 'top -b' | grep -v 'grep' | awk '{print \$2}' | xargs kill -9"
    return $?
}

check_ip_addr()
{
    ipaddr=$1
    [[ $? -ne 0 ]] && log "Non-numeric charactor exists in ip address $ipaddr" error && return 1

    a=`echo $ipaddr|awk -F . '{print $1}'`
    b=`echo $ipaddr|awk -F . '{print $2}'`
    c=`echo $ipaddr|awk -F . '{print $3}'`
    d=`echo $ipaddr|awk -F . '{print $4}'`
    for num in $a $b $c $d
    do
        if [ $num -gt 255 ] || [ $num -lt 0 ]; then
            log "Number $num is invalid" error && return 1
        fi
    done
    if [ $a -eq 0 ]; then
        log "First number $a is invalid" error && return 1
    fi
    return 0
}
