#!/bin/bash
#
# clean hostname
# ceph hosts and client in conf/common.conf
#

SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/conf/common.cfg
LOG_FILE=/var/log/ceph_install.log
remote_log=/var/log/ceph_local_install.log

remote_user=root
remote_path="/home/install/"

source $SCRIPT_HOME/common/common.sh

rm -rf /$remote_user/.ssh

for ((i=0;i<${#managerips[*]};i++))
do
  log "start to clean on ${managerips[i]} id machine" "INFO"
  /usr/bin/expect <<EOF
            set timeout 30
            spawn ssh root@${managerips[i]} rm -rf /$remote_user/.ssh
            expect {
                    "*yes/no" { send "yes\r";exp_continue }
                    "*password:" {send "huawei\r";exp_continue}
            }
            expect eof
EOF
  log "end clean on ${managerips[i]} id machine" "INFO"
done

log "install clean hosts success" info