#!/bin/bash
#
# install all ceph in hosts
# ceph hosts and client in conf/common.conf
#

SCRIPT_HOME=$(cd $(dirname $0)/; pwd)
source $SCRIPT_HOME/env_ready/env.cfg
source $SCRIPT_HOME/conf/common.cfg
source $SCRIPT_HOME/conf/manual.cfg
LOG_FILE=/var/log/ceph_install.log
remote_log=/var/log/ceph_local_install.log

remote_user=root
remote_path="/home/install/"

source $SCRIPT_HOME/env_ready/configNoPasswd.sh
source $SCRIPT_HOME/env_ready/addProfile.sh
source $SCRIPT_HOME/common/common.sh
log "@@@start check preconfig @@@" debug
log "start set proxy on first node" debug
setProxy
[[ $? -ne 0 ]]  && log "set proxy on first node failed" error &&  exit 1
log "end set proxy on first node" debug

log "start install package on first node" debug
onlineInstall
[[ $? -ne 0 ]]  && log "install on ${managerips[i]} machine failed" &&  exit 1
log "end install package on first node" debug

log "start config script format on first node" debug
script_config
[[ $? -ne 0 ]]  && log "config script format on ${managerips[i]} machine failed" &&  exit 1
log "end config script format on first node" debug

log "start config passport on first node" debug
configManagerNoPasswd
[[ $? -ne 0 ]]  && log "config passport on ${managerips[i]} machine failed" &&  exit 1
log "end config passport on first node" debug

log "@@@start check hosts success@@@" debug
for ((i=0;i<${#managerips[*]};i++))
do
  log "start to check on ${managerips[i]} id machine" debug
  exec_remote_client ${managerips[i]} "mkdir -p $remote_path"
  copy_remote_file $SCRIPT_HOME $remote_path ${managerips[i]}
  exec_remote_client ${managerips[i]} "sh ${remote_path}scripts/env_ready/checkLocal.sh ${hostnames[i]}"
  [[ $? -ne 0 ]]  && log "check on ${managerips[i]} machine failed" error && exit 1
  log "end check on ${managerips[i]} id machine" debug
done

log "@@@check all hosts success@@@" debug
exit 0
