#!/usr/bin/python

import copy
import common

data_db_wal_module={'wal_vg': 'vg1', 'wal': 'wal-lv1', 'data_vg': 'vg1', 'db_vg': 'vg2', 'db': 'db-lv1', 'data': 'data-lv1'}

def ConfigOsdYml(filePath,devNum,dbNeeded,walNeeded,osdPerDev):
    osdNum=devNum * osdPerDev

    contentModule=copy.deepcopy(data_db_wal_module)
    if (not dbNeeded):
        del contentModule['db_vg']
        del contentModule['db']

    if (not walNeeded):
        del contentModule['wal_vg']
        del contentModule['wal']

    volume = []
    ret={}
    for i in range(0,osdNum,1):
       curContent = copy.deepcopy(contentModule)
       for key in curContent:
           if key == 'wal_vg':
              curContent[key] = 'ceph-wal-db'
           elif key == 'wal':
              curContent[key] = 'wal-data' + str(i)
           elif key == 'db_vg':
              curContent[key] = 'ceph-wal-db'
           elif key ==  'db':
              curContent[key] = 'db-data' + str(i)
           elif key == 'data_vg':
              count=i/osdPerDev
              curContent[key] = 'ceph-data' + str(count)
           elif key == 'data':
              curContent[key] = 'osd-data' + str(i)
           else:
             print ('error, unkonw key %s',key)
             
       volume.append(curContent)
    ret['lvm_volumes']=volume
    ret['dummy']= None
    ret['osds_per_device']=osdPerDev
    common.DumpYmlToFile(ret, filePath)
    return 0
