declare -A rotationalMap
declare -A sizeMap
walDevice=""

GetSystemDiskInfo()
{
    local diskList=$(lsblk -d -o name,rota,size | awk '{if(NR>1) print $1}')
    local rotationalList=$(lsblk -d -o name,rota,size | awk '{if(NR>1) print $2}')
    local sizeList=$(lsblk -d -o name,rota,size | awk '{if(NR>1) print $3}')

    diskList=(${diskList// /})
    rotationalList=(${rotationalList// /})
    sizeList=(${sizeList// /})

    local num=${#diskList[@]}
    
    if (( $num == 0 ))
    then
        echo "diskList error"
        return 1
    fi

    for((i=0; i<$num;i++))
    do
        key=${diskList[$i]}
        value=${rotationalList[$i]}
        sizeV=${sizeList[$i]}
        rotationalMap[$key]=$value
        sizeMap[$key]=$sizeV
    done

}

CheckRawDiskSize()
{
    local realDiskSize=$1
    local diskSizeNeeded=$2
    local diskUnit=${realDiskSize:0-1}
    realDiskSize=${realDiskSize%$diskUnit}
    
    if [ "$diskUnit" == "T" ]
    then
        outSize=$(echo $outSize | awk '{print int($0)}' )
    elif [ "$diskUnit" == "G" ]
    then
        outSize=$( echo $realDiskSize | awk '{print int($0)}' )
    else
        echo "Disk unit is $diskUnit which is too small to use"
        return 1
    fi

    if (( diskSizeNeeded > outSize ))
    then
        echo "The needed disk size is $diskSizeNeeded, but only $realDiskSize can afford"
        return 1
    else
        return 0
    fi
}

CheckDiskInfo()
{
    local diskDevList=($1)
    local diskSize=$2

    local len=${#diskDevList[@]}
    local sum=0

    for dev in ${diskDevList[@]}
    do
        #check if disk is existed
        if [ ! -n "${rotationalMap[$dev]}" ]
        then
            echo "Disk $dev is not existed in this system"
            return 1
        else
            CheckRawDiskSize ${sizeMap[$dev]} $diskSize
            ret=$?
            
	    if [ "0" -eq $ret ]
            then
                sum=$[sum + rotationalMap[$dev]]
            else
                echo "Check disk size failed"
                return 1
            fi
        fi
    done

    if (( $sum == $len ))  || (( $sum == 0 ))
    then
        echo "Success"
    else
        echo "Not all disk type are the same"
        return 1
    fi
    return 0
}



CreateDataOsd()
{
    echo 'Begin to create data lv'
    local dataDiskDevList=($1)
    local dataDiskSize=$2
    datavgcount=0
    datalvcount=0

    for dataDev in ${dataDiskDevList[@]}
    do
        vgcreate --yes -s 1G ceph-data${datavgcount}  /dev/$dataDev
        local ret=$?
        
        if (( $ret != 0 ))
        then
            echo "Create vg /dev/${dataDev} failed "
            return 1
        fi 
        
        dataDiskSize=$(vgdisplay  ceph-data${datavgcount} | grep "Total PE" | awk '{print $3}')
        osdSize=$(echo "scale=0;${dataDiskSize}/${osd_per_dev}"|bc -l)
        
        for (( curCount=1; curCount <= osd_per_dev;curCount++))
        do
            lvcreate -y -l $osdSize -n osd-data${datalvcount} ceph-data${datavgcount}
            ret=$?
            if (($ret != 0))
            then
                echo "Create lv osd-data${count} failed "
                return 1
            fi
            datalvcount=$[datalvcount + 1]
        done   
        
        datavgcount=$[datavgcount + 1]
    done
}



ComputeDbWalDiskSize()
{
    local osdList=($1)
    local waldbDevList=($2)
    local waldbDiskNum=${#waldbDevList[@]}
	
    osdNum=${#osdList[@]}
    osdNum=$(echo "$osdNum*$osd_per_dev"|bc)

    local waldbVgSize=$(vgdisplay ceph-wal-db | grep "Total PE" | awk '{print $3}')

    if ( [ "$walNeeded" -eq "1" ]  && [ "$dbNeeded" -eq "1" ] )
    then
        walSize=$(echo "scale=0;${waldbVgSize}/${osdNum}/3*2"|bc -l)
        dbSize=$(echo "scale=0;${waldbVgSize}/${osdNum}/3*1"|bc -l)
    elif ( [ "$walNeeded" -eq "1" ] && [ "$dbNeeded" -eq "0" ] )
    then
        walSize=$(echo "scale=0;${waldbVgSize}/${osdNum}"|bc -l)
        dbSize=0
    elif ( [ "$walNeeded" -eq "0" ] && [ "$dbNeeded" -eq "1" ] )
    then
        walSize=0
        dbSize=$(echo "scale=0;${waldbVgSize}/${osdNum}"|bc -l)
    else
        walSize=0
        dbSize=0
    fi

}


GetDbWalDevInfo()
{
    local walList=($1)
    local len=${#walList[@]}

    for walDev in ${walList[@]}
    do
        local device="  /dev/"${walDev}
        walDevice="${walDevice} ${device}"
        
    done
}

CreateWalDbVg()
{
    vgcreate --yes -s 1G ceph-wal-db $walDevice
    ret=$?
    if (($ret != 0))
    then
        echo "Create wal db vg failed "
        return 1
    fi
}

CreateLv()
{
    for (( curNum=0; curNum < osdNum; curNum++))
    do
        if (( $walSize != 0 ))
        then
            lvcreate -y  -l $walSize -n wal-data${curNum} ceph-wal-db
        fi

        if (( $dbSize != 0))
        then
            lvcreate -l $dbSize -n db-data${curNum} ceph-wal-db
        fi
    done    
}

CreateDbWalDisk()
{
    echo 'Begin to create db wal lv'
    local dataDevArray=($1)
    local dbwalDevArray=($2)
    local createSize=$3

    GetDbWalDevInfo "${dbwalDevArray[*]}"
    ret=$?
    if [ "0" -ne $ret ]
    then
        echo "Get db wal dev info failed"
        return 1
    fi
    
    CreateWalDbVg
    ret=$?
    if [ "0" -ne $ret ]
    then
        echo "Create wal db vg failed"
        return 1
    fi
    
    ComputeDbWalDiskSize "${dataDevArray[*]}" "${dbwalDevArray[*]}" $createSize
    local ret=$?
    if [ "0" -ne $ret ]
    then
        echo "Compute db wal disk size failed"
        return 1
    fi


    CreateLv 
    ret=$?
    if [ "0" -ne $ret ]
    then
         echo "Create db wal lv failed"
         return 1
    fi
    return 0

}



#input $1 dataDevList   $2 dataDevSize $3 dbwalDevList  $4 dbwalDevSize $5 dbNeeded  $6 walNeeded

CreateOsdLv()
{

    GetSystemDiskInfo
        
    CheckDiskInfo "${dataDevList[*]}" $dataDevSize
    local ret=$?
    if [ 0 -ne  $ret ]
    then
        echo "Check data dev list failed"
        return 1
    fi

    echo BeginOfCheckDbWalDisk
    if  [ $dbNeeded -eq 1 ]  || [ $walNeeded -eq 1 ]
    then
        CheckDiskInfo "${dbwalDevList[*]}" $dbwalDevSize
        ret=$?
        if [ "0" -ne $ret ]
        then
            echo "Check dbwal dev list failed"
            return 1
        fi
    fi

    CreateDataOsd "${dataDevList[*]}" $dataDevSize
    ret=$?
    if [ "0" -ne $ret ]
    then
        echo "Create data lv failed"
        return 1
    fi    

    if  [ $dbNeeded -eq 1 ]  || [ $walNeeded -eq 1 ]
    then
        CreateDbWalDisk "${dataDevList[*]}" "${dbwalDevList[*]}" $dbwalDevSize
        ret=$?
        if [ "0" -ne $ret ]
        then
            echo "Create db wal lv failed"
            return 1
        fi
    fi    

    return 0            
}

dataDevList=($1)
dataDevSize=$2
dbwalDevList=($3)
dbwalDevSize=$4
dbNeeded=$5
walNeeded=$6    
osd_per_dev=$7

CreateOsdLv 

