#!/usr/bin/env bash

install_ansible()
{
    yum -y install ansible
    ret=$?
    if (( $ret !=  0 ))
    then
        echo "download ansible failed"
        return 1
    fi   
    
    return 0
}

install_git()
{
    yum -y install git
    ret=$?
    if (( $ret !=  0 ))
    then
        echo "download git failed"
        return 1
    fi

    return 0
}


download_ceph_ansible()
{
    dir=$1
    if [ ! -x "$dir" ]
    then
        mkdir "$dir"
    fi 

    cd $dir
    ret=$?
    if (( $ret != 0 ))
    then
        echo "enter $dir failed for downloading ceph ansible "
        return 1
    fi
    
    git config --global http.sslVerify false
    git clone -b stable-4.0 https://github.com/ceph/ceph-ansible.git --recursive
    ret=$?
    if (( $ret != 0 ))
    then 
        echo "download ceph ansible failed"
        return 1
    fi

    return 0
}

install_pip()
{
    yum -y install epel-release
    ret=$?
    if (( $ret != 0 ))
    then
        echo "install epel-release failed"
        return 1
    fi

    yum -y install python-pip
    ret=$?
    if (( $ret != 0 ))
    then
        echo "install python-pip failed"
        return 1
    fi

    pip install --upgrade pip
    ret=$?
    if (( $ret != 0 ))
    then
        echo "upgrade pip failed"
        return 1
    fi
    
    return 0

}

install_requirements()
{
    dir=$1
    ceph_ansibledir="/ceph-ansible/"
    dir="${1}${ceph_ansibledir}"
    
    cd $dir
    ret=$?
    if (( $ret != 0 ))
    then
        echo "enter $dir failed for downloading ceph ansible "
        return 1
    fi


    install_pip
    ret=$?
    if (( $ret != 0 ))
    then
        echo "pip install failed"
        return 1
    fi


    pip install -r requirements.txt
    ret=$?
    if (( $ret != 0 ))
    then
        echo "pip install requirements failed "
        return 1
    fi

    return 0
}

install()
{
    install_ansible
    install_git
    download_ceph_ansible $1
    install_requirements $1
}

install $1
