#!/usr/bin/python

import ansible_config_pre
import hosts
import logging as logger
import osds_yml
import site
import rgwsl_yml
import all_yml
import os
import subprocess

LOG_FILE = "/var/log/ceph_install.log"

logger.basicConfig(filename=LOG_FILE,
                  level=logger.DEBUG,
                  filemode='a',
                  format='ceph ansible install %(asctime)s %(levelname)s %(message)s')

def Download(installDir):
    cmd = "sh downlaod_software.sh " + installDir
    ret = os.system(cmd)
    if (0 != ret):
        logger.error("Download ceph ansible failed")
        return 1
    else:
        return 0

def PrepareConfig(installDir):
    rmpKeyDir=installDir+'ceph-ansible/roles/ceph-common/tasks/installs/redhat_community_repository.yml'
    ret = ansible_config_pre.comment_rpm_key(rmpKeyDir)
    if (0 != ret):
        logger.error("Commet rpm key failed")
        return 1
    else:
        return 0

    sampleDir=installDir+'ceph-ansible/group_vars/'
    ret = ansible_config_pre.CpSampleYmlToYml(sampleDir)
    if (0 != ret):
        logger.error("Commet rpm key failed")
        return 1
    else:
        return 0

def ConfigOsdYml(installDir, input):
    filePath = installDir + 'ceph-ansible/group_vars/osds.yml'
    devNum = len(input['osds'])
    dbNeeded = 1 if (input.get('db needed', 0) == 'TRUE') else 0
    walNeeded = 1 if (input.get('wal needed', 0) == 'TRUE') else 0
    osdPerDev = input['osd per dev']
    ret = osds_yml.ConfigOsdYml(filePath,devNum,dbNeeded,walNeeded,osdPerDev)
    if (0 != ret):
        logger.error("Modify osd yml failed")
        return 1
    else:
        return 0

def ConfigRgwYml(installDir, input):
    if (len(input['rgws'])):
        rgwYmlPath = installDir + 'ceph-ansible/group_vars/rgws.yml'
        ret = rgwsl_yml.ConfigRGWsYml(rgwYmlPath,input)
        if (0 != ret):
            logger.error("Modify rgws yml failed")
            return 1
    return 0

    
def ConfigSiteAndHosts(installDir, input):
    siteYmlPath = installDir + 'ceph-ansible/site.yml.sample'
    siteYmlOutPath = installDir + 'ceph-ansible/site.yml'
    ret = site.config_site_yml(siteYmlPath,siteYmlOutPath,input)
    if (0 != ret):
        logger.error("Config site yml failed")
        return 1

    hostPath = installDir + 'ceph-ansible/hosts'
    ret = hosts.CreateHosts(hostPath,input)
    if (0 != ret):
        logger.error("Config hosts  failed")
        return 1

    return 0

def ConfigYmlInGroupVars(installDir, input):
    allSampleYml='all.yml'
    outputFilePath = installDir + 'ceph-ansible/group_vars/all.yml'
    ret = all_yml.ModifyAllYml(allSampleYml, outputFilePath, input)
    if (0 != ret):
        logger.error("Modify all yml failed")
        return 1


    ret = ConfigOsdYml(installDir, input)
    if (0 != ret):
        logger.error("Modify all yml failed")
        return 1

    ret = ConfigRgwYml(installDir, input)
    if (0 != ret):
        logger.error("Modify all yml failed")
        return 1
    return 0

def ConfigYmlFile(installDir,input):
    ret = ConfigYmlInGroupVars(installDir,input)
    if (0 != ret):
        logger.error("Config yml in group vars failed")
        return 1

    ret = ConfigSiteAndHosts(installDir,input)
    if (0 != ret):
        logger.error("Config site and hosts failed")
        return 1
    return 0

def ExcuteDeploy(installDir):	
    excuteDir = installDir + 'ceph-ansible/'
    cmd = "cd " + excuteDir
    ret = os.system(cmd)
    if (0 != ret):
        logger.error("Enter %s failed", excuteDir)
        return 1
    
    cmd = "ansible-playbook -i hosts  site.yml > deploy.log"
    p = subprocess.Popen(cmd,shell=True)
    timeout=1800   #30 min to deploy
    ret = p.wait(timeout)
    if (0 != ret):
        logger.error("Deploy failed please check deploy.log in %s", excuteDir)
        return 1
    return 0

def CephAnsibleDeploy(installDir, input):
    ret = Download(installDir)
    if (0 != ret):
        logger.error("Download ceph ansible failed")
        return 1

    ret = PrepareConfig(installDir)
    if (0 != ret):
        logger.error("Prepare config file failed")
        return 1

    ret = ConfigYmlFile(installDir, input)
    if (0 != ret):
        logger.error("Config yml file failed")
        return 1

    ret = ExcuteDeploy(installDir)
    if (0 != ret):
        logger.error("Prepare config file failed")
        return 1
    return 0

dir = sys.argv[1]
inputData = sys.argv[2] 		
CephAnsibleDeploy(dir, inputData)



