#!/usr/bin/python

import sys
import ansible_config_pre
import hosts
import osds_yml
import site_yml
import rgwsl_yml
import all_yml
import os
import subprocess
import yaml
import logging as logger

LOG_FILE = "/var/log/ceph_install.log"

logger.basicConfig(filename=LOG_FILE,
                  level=logger.DEBUG,
                  filemode='a',
                  format='ceph ansible install %(asctime)s %(levelname)s %(message)s')

def Download(dir, installDir):
    logger.info('Begin to download ceph ansible')
    cmd = "sh " + dir + "/download_software.sh " + installDir
    ret = os.system(cmd)
    if (0 != ret):
        logger.error("Download ceph ansible failed")
        return 1
    logger.info('End of downloading ceph ansible')
    return 0

def PrepareConfig(dir, installDir):
    logger.info('Begin to prepare config file')
    rmpKeyDir=installDir+'ceph-ansible/roles/ceph-common/tasks/installs/redhat_community_repository.yml'
    ret = ansible_config_pre.comment_rpm_key(rmpKeyDir)
    if (0 != ret):
        logger.error("Commet rpm key failed")
        return 1

    sampleDir=installDir+'ceph-ansible/group_vars/'
    ret = ansible_config_pre.CpSampleYmlToYml(dir, sampleDir)
    if (0 != ret):
        logger.error("Commet rpm key failed")
        return 1
    
    logger.info('End of config file preparing')
    return 0

def ConfigOsdYml(installDir, input):
    filePath = installDir + 'ceph-ansible/group_vars/osds.yml'
    devNum = len(input['data_disk'])
    dbNeeded = 1 if (input.get('db_size',0) > 0)  else 0
    walNeeded = 1 if  (input.get('wal_size',0) > 0) else 0
    osdPerDev = input['osd_per_dev']
    ret = osds_yml.ConfigOsdYml(filePath,devNum,dbNeeded,walNeeded,osdPerDev)
    if (0 != ret):
        logger.error("Modify osd yml failed")
        return 1
    logger.info("Modify osd yml success")
    return 0

def ConfigRgwYml(installDir, input):
    if (len(input['rgws'])):
        rgwYmlPath = installDir + 'ceph-ansible/group_vars/rgws.yml'
        ret = rgwsl_yml.ConfigRGWsYml(rgwYmlPath,input)
        if (0 != ret):
            logger.error("Modify rgws yml failed")
            return 1
    return 0

    
def ConfigSiteAndHosts(installDir, input):
    siteYmlPath = installDir + 'ceph-ansible/site.yml.sample'
    siteYmlOutPath = installDir + 'ceph-ansible/site.yml'
    ret = site_yml.config_site_yml(siteYmlPath,siteYmlOutPath,input)
    if (0 != ret):
        logger.error("Config site yml failed")
        return 1
    logger.info("Config site yml success")

    hostPath = installDir + 'ceph-ansible/hosts'
    ret = hosts.CreateHosts(hostPath,input)
    if (0 != ret):
        logger.error("Config hosts failed")
        return 1
    else:
        logger.info("Config hosts success")
        return 0

def ConfigYmlInGroupVars(dirPath,installDir, input):
    allSampleYml=dirPath+'/all.yml'
    outputFilePath = installDir + 'ceph-ansible/group_vars/all.yml'
    ret = all_yml.ModifyAllYml(allSampleYml, outputFilePath, input)
    if (0 != ret):
        logger.error("Modify all yml failed")
        return 1


    ret = ConfigOsdYml(installDir, input)
    if (0 != ret):
        logger.error("Modify osd yml failed")
        return 1

    ret = ConfigRgwYml(installDir, input)
    if (0 != ret):
        logger.error("Modify rgw  yml failed")
        return 1
    return 0

def ConfigYmlFile(dirPath,installDir,input):
    ret = ConfigYmlInGroupVars(dirPath,installDir,input)
    if (0 != ret):
        logger.error("Config yml in group vars failed")
        return 1

    ret = ConfigSiteAndHosts(installDir,input)
    if (0 != ret):
        logger.error("Config site and hosts failed")
        return 1
    return 0

def ExcuteDeploy(installDir):	
    cephDir = installDir + 'ceph-ansible/'
    curDir = os.getcwd()
    os.chdir(cephDir)
    logger.info("Begin to deploy ceph in %s"%installDir)
    cmd = "ansible-playbook -i hosts site.yml  | tee /var/log/deploy.log"
    p = subprocess.Popen(cmd,shell=True)
    #timeout=1800   #30 min to deploy
    ret = p.wait()
    if (0 != ret):
        logger.error("Deploy failed please check deploy.log in %sceph-ansbile" %installDir)
        return 1
    os.chdir(curDir)
    return 0

def CephAnsibleDeploy():
    dirPath = os.path.abspath(os.path.dirname(__file__))
    inputConfDir = dirPath + "/../conf/ceph_install.cfg"
    installDir = dirPath + '/ceph_ansible_deploy/'
    f = open(inputConfDir,'r')
    input = f.read()
    input = yaml.safe_load(input)
    f.close()
    
    ret = Download(dirPath, installDir)
    if (0 != ret):
        logger.error("Download ceph ansible failed")
        return 1

    ret = PrepareConfig(dirPath, installDir)
    if (0 != ret):
        logger.error("Prepare config file failed")
        return 1

    ret = ConfigYmlFile(dirPath, installDir, input)
    if (0 != ret):
        logger.error("Config yml file failed")
        return 1

    ret = ExcuteDeploy(installDir)
    if (0 != ret):
        logger.error("Prepare config file failed")
        return 1
    return 0


#dir = '/home/x44/'

#inputData={'db_needed': 'Y', 'wal_needed': 'Y', 'db_wal_disk': ['nvme1n1', 'nvme0n1'], 'db_wal_disk_size': '921', 'rgw_private_devices': 'Y', 'radosgw_frontend_type': 'beast', 'radosgw_num_instances': '2', 'public_net': '90.90.1.0/24', 'public_gateway': '90.90.1.1', 'public_mask': '255.255.255.0', 'cluster_net': '90.90.2.0/24', 'cluster_gateway': '90.90.2.1', 'cluster_mask': '255.255.255.0', 'ntp_server': '90.90.1.128', 'data_disk_size': '3788', 'data_disk': ['sda', 'sdae', 'sdaj', 'sdf', 'sdk', 'sdp', 'sdu', 'sdz', 'sdaa', 'sdaf', 'sdb', 'sdg', 'sdl', 'sdq', 'sdv', 'sdab', 'sdag', 'sdc', 'sdh', 'sdm', 'sdr', 'sdw', 'sdac', 'sdah', 'sdd', 'sdi', 'sdn', 'sds', 'sdx', 'sdad', 'sdai', 'sde', 'sdj', 'sdo', 'sdt', 'sdy'], 'root_password': 'huawei', '[global]mon_max_pg_per_osd': '3000', '[global]mon_max_pool_pg_num': '300000', '[global]debug_all': 'false ', '[global]throttler_perf_counter': 'false ', '[global]ms_dispatch_throttle_bytes': '2097152000', '[global]ms_bind_before_connect': 'true ', '[mon]mon_allow_pool_delete': 'true ', '[client]rbd_cache': 'false ', '[osd]osd_max_write_size': '256', '[osd]osd_client_message_size_cap': '1048576000', '[osd]osd_map_cache_size': '1024', '[osd]bluestore_rocksdb_options': '', '[osd]bluestore_csum_type': 'none', '[osd]mon_osd_full_ratio': 0.97, '[osd]mon_osd_nearfull_ratio': 0.95, '[osd]osd_min_pg_log_entries': '10', '[osd]osd_max_pg_log_entries': '10', '[osd]bluestore_cache_kv_ratio': 0.2, '[osd]bluestore_cache_meta_ratio': 0.8, '': '', 'mons': ['ceph1', 'ceph2', 'ceph3'], 'osds': ['ceph1', 'ceph2', 'ceph3'], 'mdss': [], 'rgws': [], 'mgrs': ['ceph1', 'ceph2', 'ceph3'], 'clients': [], 'osd_per_dev': 1, 'mon_ip': {'ceph1': '90.90.1.128', 'ceph2': '90.90.1.129', 'ceph3': '90.90.1.130'}}

#print type(inputData)

inputData={"mgrs": ["ceph1", "ceph3", "ceph2"], "clients": ["client1", "client3"], "db_needed": "Y", "wal_needed": "Y", "db_wal_disk": ["nvme0n1", "nvme1n1"], "ntp_server": "192.168.20.18", "rgws": ["ceph1", "ceph3", "ceph2"], "data_disk": ["sdb", "sdc", "sdd", "sde", "sdf", "sdg", "sdh", "sdi", "sdj", "sdk", "sdl", "sdm"], "firewall_open": "N", "osds": ["ceph1", "ceph3", "ceph2"], "radosgw_frontend_type": "beast", "public_gateway": "192.168.10.1", "all_node_ssd": "N", "mdss": ["ceph1", "ceph3", "ceph2"], "osd_per_dev": 1, "host_ip": {"ceph1": "192.168.10.18", "ceph3": "192.168.10.20", "ceph2": "192.168.10.19"}, "public_mask": "255.255.255.0", "root_password": "huawei", "public_net": "192.168.10.0/24", "cluster_gateway": "192.168.20.1", "rgw_private_devices": "Y", "data_disk_size": "3700", "cluster_mask": "255.255.255.0", "mons": ["ceph1", "ceph3", "ceph2"], "db_wal_disk_size": "2900", "radosgw_num_instances": "1", "cluster_net": "192.168.20.0/24"}

if __name__ == "__main__":
    ret = CephAnsibleDeploy()
    if ret != 0:
        sys.exit(1)
    sys.exit(0)
