#!/usr/bin/python

import common

def NearbyP2(expected):
    a=1
    while(expected > a):
	a=a<<1
    if ( a - expected > expected - a/2):
        return a/2
    else:
        return a
        		
def ComputePgNum(input):
    osdNum = len(input['data_disk']) * input['osd_per_dev'] * 3
    poolNum = 0
    if(len(input['rgws'])):
        poolNum=6
    elif (len(input['mdss'])):
        poolNum=2
    else:
        poolNum=1
	
    pgNum=round(osdNum*50/3/poolNum)
    return NearbyP2(pgNum)

def AllNvmeGlobalNormalConfig(allConfMap, input):    
    allConfMap['ceph_conf_overrides']['global']['throttler_perf_counter']='false'
    allConfMap['ceph_conf_overrides']['global']['ms_dispatch_throttle_bytes']=2097152000
    allConfMap['ceph_conf_overrides']['global']['ms_bind_before_connect']='true'
    allConfMap['ceph_conf_overrides']['global']['osd_pool_default_min_size']=0
    allConfMap['ceph_conf_overrides']['global']['mon_max_pg_per_osd']=3000
    allConfMap['ceph_conf_overrides']['global']['mon_max_pool_pg_num']=300000

def AllNvmeGlobalConfigDebug(allConfMap, input):
    
    allConfMap['ceph_conf_overrides']['global']['debug_none']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_lockdep']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_context']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_crush']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mds']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mds_balancer']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mds_locker']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mds_log']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mds_log_expire']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mds_migrator']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_buffer']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_timer']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_filer']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_striper']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_objecter']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_rados']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_rbd']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_rbd_mirror']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_rbd_replay']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_journaler']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_objectcacher']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_client']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_osd']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_optracker']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_objclass']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_filestore']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_journal']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_ms']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mon']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_monc']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_paxos']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_tp']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_auth']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_crypto']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_finisher']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_reserver']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_heartbeatmap']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_perfcounter']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_rgw']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_civetweb']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_javaclient']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_asok']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_throttle']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_refs']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_xio']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_compressor']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_bluestore']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_bluefs']='0/0'

    allConfMap['ceph_conf_overrides']['global']['debug_bdev']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_kstore']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_rocksdb']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_leveldb']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_memdb']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_kinetic']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_fuse']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mgr']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_mgrc']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_dpdk']='0/0'
    allConfMap['ceph_conf_overrides']['global']['debug_eventtrace']='0/0'
	
def ConfigGlobalInfo(allConfMap, input):
   
    pgNum=ComputePgNum(input)
    allConfMap['ceph_conf_overrides']['global']['osd_pool_default_pg_num']=pgNum
    allConfMap['ceph_conf_overrides']['global']['osd_pool_default_pgp_num']=pgNum
    if (input['all_node_ssd'] == 'Y'): 
        AllNvmeGlobalNormalConfig(allConfMap, input)
        AllNvmeGlobalConfigDebug(allConfMap, input)   
	
def ConfigClientInfo(allConfMap, input):
    allConfMap['ceph_conf_overrides']['client'] = {}
    allConfMap['ceph_conf_overrides']['client']['rbd_cache']='false'    


def ConfigOsdInfo(allConfMap, input):
    allConfMap['ceph_conf_overrides']['osd'] = {}
    allConfMap['ceph_conf_overrides']['osd']['osd_max_write_size']=256
    allConfMap['ceph_conf_overrides']['osd']['osd_client_message_size_cap']=1073741824
    allConfMap['ceph_conf_overrides']['osd']['osd_map_cache_size']=1024
    allConfMap['ceph_conf_overrides']['osd']['bluestore_rocksdb_options']='compression=kNoCompression,max_write_buffer_number=64,min_write_buffer_number_to_merge=32,recycle_log_file_num=64,compaction_style=kCompactionStyleLevel,write_buffer_size=4MB,target_file_size_base=4MB,max_background_compactions=16,level0_file_num_compaction_trigger=64,level0_slowdown_writes_trigger=128,level0_stop_writes_trigger=256,max_bytes_for_level_base=6GB,compaction_threads=8,flusher_threads=4,compaction_readahead_size=2MB'
    allConfMap['ceph_conf_overrides']['osd']['bluestore_csum_type']='none'
    allConfMap['ceph_conf_overrides']['osd']['mon_osd_nearfull_ratio']=0.95
    allConfMap['ceph_conf_overrides']['osd']['mon_osd_full_ratio']=0.97
    allConfMap['ceph_conf_overrides']['osd']['osd_min_pg_log_entries']=10
    allConfMap['ceph_conf_overrides']['osd']['osd_max_pg_log_entries']=10
    allConfMap['ceph_conf_overrides']['osd']['bluestore_cache_meta_ratio']=0.8
    allConfMap['ceph_conf_overrides']['osd']['bluestore_cache_kv_ratio']=0.2

def ConfigCephConfOverride(allConfMap, input):
    ConfigGlobalInfo(allConfMap, input)
    if (input['all_node_ssd'] == 'Y'):
        ConfigOsdInfo(allConfMap, input)
        ConfigClientInfo(allConfMap, input)

	
    
def ConfigObjectStore(allConfMap):
    allConfMap['osd_objectstore'] = 'bluestore'


def ProcessCephfs(allConfMap,input):
    if (0 == len(input['mdss'])):
        del allConfMap['cephfs_data_pool']
	del allConfMap['cephfs']
	del allConfMap['cephfs_pools']  
	del allConfMap['cephfs_metadata_pool'] 	
		
def ProcessRadosgw(allConfMap,input):
    if ( 0 == len(input['rgws']) ):
	#del allConfMap['radosgw_interface']
	del allConfMap['radosgw_frontend_port']
	del allConfMap['radosgw_frontend_type'] 
        del allConfMap['radosgw_num_instances']
        del allConfMap['radosgw_civetweb_port']
        del allConfMap['radosgw_civetweb_num_threads']
        del allConfMap['radosgw_civetweb_options'] 		
    else:
        allConfMap['radosgw_frontend_type']=input['radosgw_frontend_type']
        allConfMap['radosgw_num_instances'] = input['radosgw_num_instances']
		
def ConfigNetwork(allConfMap,input):
    allConfMap['public_network']=input['public_net']
    allConfMap['cluster_network']=input['cluster_net']

def ConfigCephVersion(allConfMap,input):
    allConfMap['ceph_stable_release']=input['ceph_version']
    allConfMap['ceph_stable_redhat_distro']=allConfMap['ceph_stable_redhat_distro']

def OpenFirewall(allConfMap,input):
    if (0 == len(input['mdss'])):
        del allConfMap['ceph_mds_firewall_zone']
    if (0 == len(input['rgws'])):    
        del allConfMap['ceph_rgw_firewall_zone']

def ConfigFirewall(allConfMap,input):
    if (input['firewall_open'] == 'N'):
        allConfMap['configure_firewall'] = 'false'
        del allConfMap['ceph_mon_firewall_zone']
        del allConfMap['ceph_mgr_firewall_zone']
        del allConfMap['ceph_osd_firewall_zone']
        del allConfMap['ceph_rgw_firewall_zone']
        del allConfMap['ceph_mds_firewall_zone']        
    else:
	OpenFirewall(allConfMap,input)

def ConfigNtp(allConfMap,input):
    allConfMap['ntp_service_enabled'] = 'false'
	
def ConfigAllYml(allConfMap, input):
    ConfigCephConfOverride(allConfMap, input)	
    ConfigObjectStore(allConfMap)
    ProcessCephfs(allConfMap,input)	
    ProcessRadosgw(allConfMap,input)
    ConfigNetwork(allConfMap,input)
    ConfigCephVersion(allConfMap,input)
    ConfigFirewall(allConfMap,input)
    ConfigNtp(allConfMap,input)

def ModifyAllYml(sampleFilePath,outputFilePath,input): 
    mapInfo = common.LoadYmlSample(sampleFilePath)
    ConfigAllYml(mapInfo,input)
    common.DumpYmlToFile(mapInfo,outputFilePath)
    return 0
	
#input={}
#input['mons']=['ceph1','ceph3']
#input['mdss']=[]
#input['rgws']=[]
#input['clients']=['client1']
#input['mgrs']=['ceph1','ceph2','ceph3','ceph4']
#input['osds']=['sda','sdb']
#input['radosgw_frontend_type']=['beast']
#input['radosgw_frontend_port']=[8080]
#input['radosgw_interface']=['enp5']
#input['radosgw_num_instances']=[10]
#input['public_network']='90.90.64.1/0'
#input['cluster_network']='90.90.64.1/0'
#input['public']=['enp125s0f0']
##ModifyAllYml('all.yml', '/home/x33/test/ceph-ansible/group_vars/all.yml', input)	
