#!/bin/bash

function check_network(){
  #内部环境信息请配置正确的代理
  SCRIPT_HOME=$(
  cd $(dirname $0)/
  pwd
)
  source $SCRIPT_HOME/scripts/conf/manual.cfg
  export http_proxy=$config_proxy
  export https_proxy=$config_proxy
  export no_proxy=$config_no_proxy
  curl http://download.ceph.com >/dev/null
  [[ $? -ne 0 ]] && return 1
  return 0
}

function env_ready() {
  yum -y install epel-release expect > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1
  yum clean all > /dev/null 2>&1;yum makecache > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1

  yum -y install python-pip > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1

  pip install xlrd pyyaml > /dev/null 2>&1
  [[ $? -ne 0 ]] && return 1
  return 0
}

check_network
[[ $? -ne 0 ]] && echo "networt is ready ---------------------------------------------------------nok" && exit 1
echo "networt  ---------------------------------------------------------ok"

env_ready
[[ $? -ne 0 ]] && echo "install package failed ---------------------------------------------------------nok" && exit 1
echo "install package---------------------------------------------------------ok"

python input_opt.py
[[ $? -ne 0 ]]  && echo "parse parameter    ---------------------------------------------------------nok" && exit 1
echo "parse parameter    ---------------------------------------------------------ok"

sh scripts/clean.sh

sh scripts/check_hosts.sh
[[ $? -ne 0 ]]  && echo "check hosts    ---------------------------------------------------------nok" && exit 1
echo "parse parameter    ---------------------------------------------------------ok"