#!/bin/bash

# 参数设置
# 数据库名称
database_name=tpch_60g_noindex
# 生成数据大小，单位为G
tpch_data_size=60

make

# 数据保存目录
save_sql_dir="tpch_${tpch_data_size}g"
echo "数据保存目录：${save_sql_dir}"

# 如果数据不存在则生成数据
if [ ! -d ${save_sql_dir} ]; then
    echo -e "\033[35m生成 ${tpch_data_size}g 数据...\033[0m"
    ./dbgen -s ${tpch_data_size}
    echo -e "\033[35m生成数据完毕\033[0m"
    echo -e "\033[35m保存数据\033[0m"
    mkdir ${save_sql_dir}
    mv *.tbl ${save_sql_dir}   
fi

# 修改数据库名称
rm -rf dss.ddl dss.ri load.sh
cp conf/dss.ddl ./
cp conf/dss.ri ./
cp conf/load.sh ./
sed -i "s/tpch_1t/${database_name}/g" dss.ddl
sed -i "s/tpch_1t/${database_name}/g" dss.ri
sed -i "s/tpch_1t/${database_name}/g" load.sh

# 建tpch数据库及表
mysql -uroot -p123456 < dss.ddl

index=$1
if [[ ${index} == "noindex" ]]; then
    echo "no index"
else
    # 添加tpch主键和外键
    mysql -uroot -p123456 < dss.ri
    echo index
fi

# 导入数据
cp load.sh ${save_sql_dir}
cd ${save_sql_dir}
bash load.sh
echo -e "\033[35m导入${tpch_data_size}g 数据，请耐心等待...\033[0m"
mysql -uroot -p123456 < loaddata.sql
echo -e "\033[35m导入${tpch_data_size}g 数据完毕\033[0m"

rm -rf load.sh loaddata.sql

