#!/usr/bin/env bash
THDS=${THDS:-'64 128 256 512'}
#THDS=${THDS:-'32'}
date=`date +%F-%H-%M`
FILE="normal_data.log_${date}"
TMP_FILE="tmp_data.log_${date}"
TEST=/home/sysbench-0.5/sysbench/tests/db/oltp.lua
HOME=/home/sysbench-0.5/sysbench/tests/db/
ENGINE=innodb
HOST=192.168.190.31

DB=sysbench
PORT=3306
TIME=${TIME:-120}
CNT=100
SIZE=1000000
CMD=run

SLEEP_TIME=${TIME:-60}
TYPE=normal
SUB_THD=32

USER=root
PASSWORD=123456


while getopts ":h:H:P:c:d:e:T:t:u:p:D:C:S:" opt
do
    case $opt in
        h) HOST=$OPTARG;;
        H) HOME=$OPTARG;;
        P) PORT=$OPTARG;;
        c) CMD=$OPTARG;;
        d) DB=$OPTARG;;
        e) ENGINE=$OPTARG;;
        T) TYPE=$OPTARG;;
        t) THDS=$OPTARG;;
        u) USER=$OPTARG;;
        p) PASSWORD=$OPTARG;;
        D)  DB=$OPTARG;;
        C)  CNT=$OPTARG;;
        S)  SIZE=$OPTARG;;


    esac
done

if [ "$TYPE" = "check" ]; then
    CNT=1
    SIZE=1
    TIME=1 
    SLEEP_TIME=1
fi

echo "CMD=$CMD ENGINE=$ENGINE"

export LD_LIBRARY_PATH=$HOME/lib:$LD_LIBRARY_PATH

echo "==========oltp-delete============"  >> $FILE
echo "THD    TPS          QPS           RT      transactions  read_write_requests   CPU"  >> $FILE
if [ "$CMD" = "run" ]; then
    for THD in ${THDS[@]}
    do
        BEGIN_CPU=`cat /proc/stat | head -1 | awk {'print $2'}`

        /home/sysbench-0.5/sysbench/sysbench --db-driver=mysql --debug=off --test=$TEST --oltp-tables-count=$CNT \
		--mysql-db=$DB --mysql-password=$PASSWORD \
		--oltp-distinct-ranges=0 --oltp-index-updates=0 --oltp-non-index-updates=0 --oltp-order-ranges=0 --oltp-point-selects=0 --oltp-simple-ranges=0 --oltp-sum-ranges=0 --oltp_delete_inserts=1 \
		--oltp-table-size=$SIZE --num-threads=$THD --max-requests=0 --max-time=$TIME --oltp-auto-inc=off --mysql-engine-trx=yes --oltp-test-mod=complex --mysql-host=$HOST --mysql-port=$PORT --mysql-user=$USER --oltp-user-delay-min=10  --oltp-user-delay-max=100 --report-interval=${REPORT_INTERVAL:-1} --forced-shutdown=1 run | tee -a $TMP_FILE
		
        END_CPU=`cat /proc/stat | head -1 | awk {'print $2'}`
TPS=`cat $TMP_FILE |  egrep " cat|transactions:" |  awk {'print $3'} |awk -F\( {'print $2'}  | awk -F: 'END{print $NF}'`       
QPS=`cat $TMP_FILE | egrep " cat|write requests:" |  awk {'print $1 $4'} | awk -F\( '{print $2}' | awk -F: 'END{print $NF}'`
        RT=`cat $TMP_FILE | egrep " cat|approx." |  awk {'print $4'} | sed 's/[A-Za-z]//g' | awk -F: 'END{print $NF}'`
        let CPU=END_CPU-BEGIN_CPU
transactions=`cat $TMP_FILE |  egrep " cat|transactions:" |  awk {'print $2'}  | awk -F: 'END{print $NF}'`
read_write_requests=`cat $TMP_FILE | egrep " cat|write requests:" |  awk {'print $3'} | awk -F: 'END{print $NF}' `
echo "$THD     $TPS      $QPS        $RT          $transactions           $read_write_requests       $CPU" >> $FILE
done
else
    /home/sysbench-0.5/sysbench/sysbench --db-driver=mysql --debug=off --test=$TEST \
    --oltp-tables-count=$CNT --oltp-point-selects=0 --oltp-table-size=$SIZE \
    --num-threads=$SUB_THD --max-requests=0 --max-time=$TIME --oltp-auto-inc=off --mysql-engine-trx=yes --oltp-test-mod=complex  --mysql-host=$HOST --mysql-port=$PORT --mysql-user=root --oltp-user-delay-min=10 --oltp-user-delay-max=100 --report-interval=5 $CMD
fi

#### for example
### sh data_pressure_test.sh -T check -h 127.0.0.1 -P 25616 -c prepare
