#!/bin/bash
dbType=""
func=""
filePath=""
fileType=""
conf=""
os_root_user=""
os_root_password=""
remotedir="/home/dbinstall"
confname=""
filename=""



helper()
{
    echo "sh tsdbtool.sh parm1 parm2 parm3 <parm4>"
    echo "parm1: check/install/uninstall"
    echo "pram2: dbtype=dbname dbname:mysql/postgresql/mongodb/greenplum"
    echo "parm3: conf=/path/to/file"
    echo "parm4: rpmdir=/path/to/file or sourcedir=/path/to/file"
    echo "for example:"
    echo "sh tsdbtool.sh check dbtype=mysql conf=/root/installconf.csv rpmdir=/root/mysql.rpm"
    echo "or sh tsdbtool.sh uninstall dbtype=mysql conf=/root/installconf.csv"

}

getparm1()
{
    local parm1=$1
    func=${parm1}
    if [ ${func} == "help" ];then
        helper
        exit 0
    elif [ ${func} == "install" ] || [ ${func} == "check" ] || [ ${func} == "uninstall" ] || [ ${func} == "compile" ];then
        echo "begin to ${func}"
    else
        echo "unsupport parm:${func}"
        exit 0
    fi
}
getparm2and3()
{
    local parm2=$1
    local parm3=$2
    local var1=`echo ${parm2} | awk -F '=' '{print $1}'`
    if [ ${var1}x == "dbtypex" ];then
       dbType=`echo ${parm2} | awk -F '=' '{print $2}'`
    else
       echo "unsupport parm2:${var1}"
       exit 0
    fi

    local var2=`echo ${parm3} | awk -F '=' '{print $1}'`    
    if [ ${var2}x == "confx" ];then
       conf=`echo ${parm3} | awk -F '=' '{print $2}'`
    else
       echo "unsupport parm3:${var2}"
       exit 0
    fi

    if [ ! -f ${conf} ];then
        echo "can not find ${conf}"
        exit 0;
    fi
    confname=`echo ${conf} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

    os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    
}

getparm4()
{
    local parm4=$1
    fileType=`echo ${parm4} | awk -F '=' '{print $1}'`
    if [ ${fileType}x == "rpmdirx" ] || [ ${fileType}x == "sourcedirx" ];then
       filePath=`echo ${parm4} | awk -F '=' '{print $2}'`
    else
       echo "unsupport parm:${fileType}"
       exit 0
    fi
     
    if [ ${func} == "compile" ] && [ ${fileType} != "sourcedir" ];then
       echo "compile must give sourcedir in parm4"
       exit 0
    fi
    
    if [ ! -f ${filePath} ];then
       echo "can not find ${filePath}"
       exit 0
    fi
    filename=`echo ${filePath} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
}

getparm()
{
   getparm1 $1
   getparm2and3 $2 $3
   if [ ${func}x != "uninstallx" ];then
       getparm4 $4
   fi

}

getparm_old()
{
    local parm1=$1
    local parm2=$2
    local parm3=$3
    local parm4=$4
    
    func=${parm1}
    if [ ${func} == "help" ];then
        helper
        exit 0
    fi
    
    dbType=`echo ${parm2} | awk -F '=' '{print $2}'`
    
    conf=`echo ${parm3} | awk -F '=' '{print $2}'`
    if [ ! -f ${conf} ];then
        echo "can not find ${conf}"
        exit 0;
    fi
    confname=`echo ${conf} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


    fileType=`echo ${parm4} | awk -F '=' '{print $1}'`
    filePath=`echo ${parm4} | awk -F '=' '{print $2}'`
    # check conf and file existence or not
    if [ ${func} != "uninstall" ] && [ ! -f ${filePath} ];then
        echo "can not find ${filePath}"
        exit 0;
    fi
    filename=`echo ${filePath} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
#    printf "fun=%s-type=%s-ftype=%s-dir=%s\n" ${func} ${dbType} ${fileType} ${filePath}
}


sshCheck()
{
    local remotehost=$1
        ping -c2 -W2 ${remotehost} &> /dev/null
        if [ $? -ne 0 ];then
            echo "can not connect host:${remotehost}"
            return 1
        fi
        expect <<-EOF
		set timeout 3
        spawn ssh ${os_root_user}@${remotehost}
        expect {
             "yes/no" {send "yes\r";exp_continue}
             "password:" {send "${os_root_password}\r"}
       }
       expect "password:" {
         exit 1
       }
       expect "#"
       send "exit\r"
       expect eof
       exit 2
EOF


       if [ $? == 2 ];then
           echo "ssh connect ${remotehost} check success"
           return 0
       else
           echo "ssh connect ${remotehost} failed,please check the paasword"
           return 1
       fi
    
}


remotecopy()
{
    local host=`grep "host" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    echo "conf host is ${host}"
    if [ ${host} != "localhost" ];then
    #copy script to remote host
        local  hostarr=(`echo ${host} |tr ';' ' '`)
        echo ${hostarr[@]}
        local toolPath=$(dirname $(readlink -f $0))
        
        for h in ${hostarr[@]}
        do        
           sshCheck ${h}
           if [ $? == 1 ]; then
                exit 0
           fi
        done
 
        for h in ${hostarr[@]}
        do

           expect <<-EOF
           spawn ssh ${os_root_user}@${h}
           expect {
             "yes/no" {send "yes\r";exp_continue}
             "password:" {send "${os_root_password}\r"}
           }
           expect "]#"
           send "rm -rf ${remotedir}\r"
           expect "]#"
           send "mkdir ${remotedir}\r"
           expect "]#"
           send "exit\r"
           expect eof
EOF


           expect <<-EOF
           spawn bash -c "scp -r ${toolPath}/* ${os_root_user}@${h}:${remotedir}"
           expect {
             "yes/no" {send "yes\r";exp_continue}
             "password:" {send "${os_root_password}\r"}
           }
           expect eof

EOF
          expect <<-EOF        
          spawn bash -c "scp -r ${filePath} ${conf} ${os_root_user}@${h}:${remotedir}"
          expect {
             "yes/no" {send "yes\r";exp_continue}
             "password:" {send "${os_root_password}\r"}
           }
          expect eof
EOF
          
        done

   fi

}

mysqlfunc()
{
    host=`grep "host" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    
    if [ ${host} == "localhost" ]; then
        if [ ${func} == "check" ];then
            ./mysqlCheck.sh ${conf} ${fileType} ${filePath}
        fi
        
        if [ ${func} == "compile" ];then
            ./mysqlInstall.sh ${conf} compile ${filePath}
        fi

        if [ ${func} == "install" ];then  
            if [ ${fileType}x == "rpmdirx" ];then
                ./mysqlInstall.sh ${conf} rpminstall ${filePath}
            fi
            if [ ${fileType}x == "sourcedirx" ];then
                ./mysqlInstall.sh ${conf} sourceinstall ${filePath}
            fi
        fi
        if [ ${func} == "uninstall" ];then
            while :
            do
            echo "uninstall mysql will stop db and delete data/log/software files and dir:"
            echo "input yes/no:"
            read input
            case ${input} in
            "yes"|"y"|"YES"|"Y")
                 
                 ./mysqlUninstall.sh ${conf} ${fileType}
                 break
                 ;;
            "no"|"n"|"NO"|"N")
                 exit 0
                 ;;
            *)
                 continue
                 ;;
            esac
            done

        fi
     else
        hostarr=(`echo ${host} |tr ';' ' '`)
        echo ${hostarr[@]}
        for h in ${hostarr[@]}
        do
              
            if [ ${func} == "check" ];then
                 remotecopy
                 expect <<-EOF
                 spawn ssh ${os_root_user}@${h}
                 expect {
                 "yes/no" {send "yes\r";exp_continue}
                 "password:" {send "${os_root_password}\r"}
                 }
                 expect "]#"
                 send "sh ${remotedir}/mysqlCheck.sh ${remotedir}/${confname} ${fileType} ${remotedir}/${filename}\r"
                 
                 expect "]#"
                 send "exit\r"
                
EOF
            fi
            if [ ${func} == "uninstall" ];then
                while :
                do
                echo "uninstall mysql will stop db and delete data/log/software files and log :"
                echo "input yes/no:"
                read input
                case ${input} in
                "yes"|"y"|"YES"|"Y")
                     expect <<-EOF
                     set timeout 7200
                     spawn ssh ${os_root_user}@${h}
                     expect {
                     "yes/no" {send "yes\r";exp_continue}
                     "password:" {send "${os_root_password}\r"}
                     }
                     expect "*]#"
                     send "sh ${remotedir}/mysqlUninstall.sh  ${remotedir}/${confname} ${fileType}\r"

                     expect "*]#"
                     send "exit\r"
                   
EOF

                 break
                 ;;
                 "no"|"n"|"NO"|"N")
                     exit 0
                     ;;
                 *)
                     continue
                     ;;
                 esac
                 done

             fi

 
             if [ ${func} == "install" ];then
                  if [ ${fileType}x == "rpmdirx" ];then
                      ./mysqlInstall.sh ${conf} rpminstall ${filePath}
                       expect <<-EOF
                      set timeout 7200
                      spawn ssh ${os_root_user}@${h}
                      expect {
                      "yes/no" {send "yes\r";exp_continue}
                      "password:" {send "${os_root_password}\r"}
                      }
                      expect "]#"
                      send "sh ${remotedir}/mysqlInstall.sh  ${remotedir}/${confname} rpminstall ${remotedir}/${filename}\r"

                      expect "]#"
                      send "exit\r"
EOF

                  fi



                  if [ ${fileType}x == "sourcedirx" ];then
               
                      expect <<-EOF
                      set timeout 7200
                      spawn ssh ${os_root_user}@${h} 
                      expect {
                      "yes/no" {send "yes\r";exp_continue}
                      "password:" {send "${os_root_password}\r"}
                      }
                      expect "]#"
                      send "sh ${remotedir}/mysqlInstall.sh  ${remotedir}/${confname} sourceinstall ${remotedir}/${filename}\r"
  
                      expect "]#"
                      send "exit\r"  
              
EOF
                  fi
             fi

        done

    fi


}


postgresqlfunc()
{
    host=`grep "host" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

    if [ ${host} == "localhost" ]; then
        if [ ${func} == "check" ];then
            ./postgresqlCheck.sh ${conf} ${fileType} ${filePath}
        fi
        
        if [ ${func} == "compile" ];then
            ./postgresqlInstall.sh ${conf} compile ${filePath}
        fi


        if [ ${func} == "install" ];then
             if [ ${fileType}x == "rpmdirx" ];then
                ./postgresqlInstall.sh ${conf} rpminstall ${filePath}
            fi
            if [ ${fileType}x == "sourcedirx" ];then
                ./postgresqlInstall.sh ${conf} sourceinstall ${filePath}
            fi

        fi
        if [ ${func} == "uninstall" ];then
            while :
            do
            echo "uninstall postgresql will stop db and delete data/wal/software files and dir:"
            echo "input yes/no:"
            read input
            case ${input} in
            "yes"|"y"|"YES"|"Y")

                 ./postgresqlUninstall.sh ${conf} ${fileType}
                 break
                 ;;
            "no"|"n"|"NO"|"N")
                 exit 0
                 ;;
            *)
                 continue
                 ;;
            esac
            done

        fi
     else
         hostarr=(`echo ${host} |tr ';' ' '`)
         echo ${hostarr[@]}
         for h in ${hostarr[@]}
         do

            if [ ${func} == "check" ];then
                 remotecopy
                 expect <<-EOF
                 spawn ssh ${os_root_user}@${h}
                 expect {
                 "yes/no" {send "yes\r";exp_continue}
                 "password:" {send "${os_root_password}\r"}
                 }
                 expect "]#"
                 send "sh ${remotedir}/postgresqlCheck.sh ${remotedir}/${confname} ${fileType} ${remotedir}/${filename}\r"

                 expect "]#"
                 send "exit\r"

EOF
            fi
                
            if [ ${func} == "uninstall" ];then
                while :
                do
                echo "uninstall postgresql will stop db and delete data/val/software files and log :"
                echo "input yes/no:"
                read input
                case ${input} in
                "yes"|"y"|"YES"|"Y")
                     expect <<-EOF
                     set timeout 7200
                     spawn ssh ${os_root_user}@${h}
                     expect {
                     "yes/no" {send "yes\r";exp_continue}
                     "password:" {send "${os_root_password}\r"}
                     }
                     expect "*]#"
                     send "sh ${remotedir}/postgresqlUninstall.sh  ${remotedir}/${confname} ${fileType}\r"

                     expect "*]#"
                     send "exit\r"

EOF

                 break
                 ;;
                 "no"|"n"|"NO"|"N")
                     exit 0
                     ;;
                 *)
                     continue
                     ;;
                 esac
                 done
             fi
             if [ ${func} == "install" ];then


                  if [ ${fileType}x == "rpmdirx" ];then
                      ./mysqlInstall.sh ${conf} rpminstall ${filePath}
                       expect <<-EOF
                      set timeout 7200
                      spawn ssh ${os_root_user}@${h}
                      expect {
                      "yes/no" {send "yes\r";exp_continue}
                      "password:" {send "${os_root_password}\r"}
                      }
                      expect "]#"
                      send "sh ${remotedir}/postgresqlInstall.sh  ${remotedir}/${confname} rpminstall ${remotedir}/${filename}\r"

                      expect "]#"
                      send "exit\r"
EOF

                  fi



                  if [ ${fileType}x == "sourcedirx" ];then

                      expect <<-EOF
                      set timeout 7200
                      spawn ssh ${os_root_user}@${h}
                      expect {
                      "yes/no" {send "yes\r";exp_continue}
                      "password:" {send "${os_root_password}\r"}
                      }
                      expect "]#"
                      send "sh ${remotedir}/postgresqlInstall.sh  ${remotedir}/${confname} sourceinstall ${remotedir}/${filename}\r"

                      expect "]#"
                      send "exit\r"

EOF
                 fi 
             fi

        done

        
     fi
}


mongodbfunc()
{
      if [ ${func} == "check" ];then
            ./mongoCheck.sh ${conf} ${fileType} ${filePath}
        fi

       
        if [ ${func} == "compile" ];then
            ./mongoInstall.sh ${conf} compile ${filePath}
        fi


        if [ ${func} == "install" ];then
            if [ ${fileType}x == "rpmdirx" ];then
                ./mongoInstall.sh ${conf} rpminstall ${filePath}
            fi
            if [ ${fileType}x == "sourcedirx" ];then
                ./mongoInstall.sh ${conf} sourceinstall ${filePath}
            fi     
        fi
        if [ ${func} == "uninstall" ];then
            while :
            do
            echo "uninstall mongodb will stop db and delete config/shard/router/software files and dir:"
            echo "input yes/no:"
            read input
            case ${input} in
            "yes"|"y"|"YES"|"Y")

                 ./mongoUninstall.sh ${conf} ${fileType}
                 break
                 ;;
            "no"|"n"|"NO"|"N")
                 exit 0
                 ;;
            *)
                 continue
                 ;;
            esac
            done

        fi



}


greenplumfunc()
{
    local seg_server=`grep "seg_server," ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    local master_server=`grep "master_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    local standby_server=`grep "standby_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

    local seg_server_list=(`echo ${seg_server} |tr ';' ' '`)
    local all_server="${seg_server};${master_server};${standby_server}"
    local all_server_list=(`echo ${all_server} |tr ';' ' '`)
    all_server_list=(`echo ${all_server_list[@]} | sed 's/ /\n/g' | sort | uniq`)
    all_server=`echo ${all_server_list[@]} | sed 's/ /;/g'`
   
    if [ ${func} == "check" ];then
        sh greenplumCheck.sh  ${conf} ${fileType} ${filePath}
    fi


    if [ ${func} == "compile" ];then
         sh greenplumInstall.sh ${conf} compile ${filePath}
    fi


    if [ ${func} == "install" ];then
        for serverip in ${all_server_list[@]}
        do
            local remotedir=/tmp/dbinstall
            ssh -tt ${os_root_user}@${serverip} <<-EOF
            if [ -d ${remotedir} ];then
                rm -rf ${remotedir}
            fi
            mkdir -p ${remotedir}
            exit
EOF
            if [ ${fileType}x == "sourcedirx" ];then 
                scp -r greenplum* ${os_root_user}@${serverip}:${remotedir}
                scp -r ${filePath} ${conf} ${os_root_user}@${serverip}:${remotedir}
                ssh -tt  ${os_root_user}@${serverip} <<-EOF
                cd ${remotedir}
                sh greenplumInstall.sh ${remotedir}/${confname} sourceinstall ${remotedir}/${filename}
exit    
EOF
           fi
 
           if [ ${fileType}x == "rpmdirx" ];then
                scp -r greenplum* ${os_root_user}@${serverip}:${remotedir}
                scp -r ${filePath} ${conf} ${os_root_user}@${serverip}:${remotedir}
                ssh -tt  ${os_root_user}@${serverip} <<-EOF
                cd ${remotedir}
                sh greenplumInstall.sh ${remotedir}/${confname} rpminstall ${remotedir}/${filename}
exit
EOF
           fi

        done
        sh greenplumInit.sh ${conf} ${fileType}
    fi

    if [ ${func} == "uninstall" ];then
        while :
            do
            echo "uninstall greenolum will stop db and delete mirror/seg/router/software files and dir:"
            echo "input yes/no:"
            read input
            case ${input} in
            "yes"|"y"|"YES"|"Y")

                 sh greenplumUninstall.sh ${conf} ${fileType}
                 break
                 ;;
            "no"|"n"|"NO"|"N")
                 exit 0
                 ;;
            *)
                 continue
                 ;;
            esac
            done
    fi

}
main(){
    chmod +x *sh
    if [ ${dbType}x == "mysqlx" ];then
        mysqlfunc

    elif [ ${dbType}x == "postgresqlx" ];then
        postgresqlfunc
    elif [ ${dbType}x == "mongodbx" ];then
        mongodbfunc
    elif [ ${dbType}x == "greenplumx" ];then
        greenplumfunc
    else
        echo "dbtype error,not support"
        echo "use:sh tsdbtool help to help"
    fi



}

if [ $# == 0 ] || [ $# == 2 ] || [ $# -gt 4 ];then
    helper
    exit 0
fi

#getparm $1 $2 $3 $4
getparm $@

main


