#!/bin/bash
#use: ./postgresqlInstall.sh ${conf} ${fileType} ${filePath}

conf=$1
fileType=$2
filePath=$3
isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
db_password=`grep "db_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
datadir=`grep "datadir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
waldir=`grep "waldir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
#mkdir ${tempDir}
depDir=${toolPath}/postgresqlDep
cnfPath=""
installLog=${toolPath}/postgresqlInstall.log
touch ${installLog}
chmod 666 ${installLog}


startPg()
{
    local line=`rpm -qa |grep postgresql | wc -l`
    if [ ${line} -gt 0 ];then
        prefixdir="/usr/local/pgsql"
    fi

    su - postgres <<-EOF
    cd ${prefixdir}/bin
    ./pg_ctl -D ${datadir} -l ${waldir}/pglog start
EOF

    line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
    count=1
    while [ ${count} -le 5 ] && [ ${line} -le 5 ]
    do
        sleep 5
        line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
        count=`expr ${count} + 1`
    done

    if [ ${count} -gt 5 ];then
        echo "postgresql start failed" >> ${installLog}
        echo "postgresql start failed"
        exit  0
    else
        sleep 5
        echo "postgresql start success" >> ${installLog}
        echo "postgresql start success"
    fi

    
}

stopPg()
{
    local line=`rpm -qa |grep postgresql | wc -l`
    if [ ${line} -gt 0 ];then
        prefixdir="/usr/local/pgsql"
    fi

    su - postgres <<-EOF
    cd ${prefixdir}/bin
    ./pg_ctl -D ${datadir} -l ${waldir}/pglog stop
EOF
  
   local line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
   local count=1
    while [ ${count} -le 5 ] && [ ${line} -gt 0 ]
    do
        sleep 5
        line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
        count=`expr ${count} + 1`
    done

    if [ ${count} -gt 5 ];then
        echo "postgresql stop failed" >> ${installLog}
        echo "postgresql stop failed"
        exit  0
    else
        sleep 5
        echo "postgresql stop success" >> ${installLog}
        echo "postgresql stop success"
    fi

    

}

Uninstall()
{
    local line=`rpm -qa |grep postgresql | wc -l`
    if [ ${line} -gt 0 ];then
        local pgrpm=`rpm -qa |grep postgresql`

        rpm -e ${pgrpm}
        prefixdir="/usr/local/pgsql"
    fi
    del=(${prefixdir} ${datadir} ${waldir})
    echo "uninstall db,  delete the files: ${del[@]}"
    rm -rf ${prefixdir}/* ${datadir}/* ${waldir}/*
	rm -rf ${depDir}/temppy_src ${depDir}/temppg_src

}
main()
{
    local line=`ps -ef |grep "postgres:" |grep -v "grep"|wc -l`
    if [ ${line} -gt 0 ];then
       stopPg
    fi
    Uninstall


}


main
echo "postgresqlUninstall.sh complete!!"
echo "postgresqlUninstall.sh complete!!" >> ${installLog}









