#!/bin/bash
#use: postgresqlChech conf fileType filePath
conf=$1
fileType=$2
filePath=$3

isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
host=`grep "host" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

datadir=`grep "datadir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
waldir=`grep "waldir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

prefixdir=`grep "prefix" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
compile_flag=`grep "compile_flag" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
depDir=${toolPath}/postgresqlDep


RPMMD5=(
7ee70fce9a738ffa7a497c5cd43d6efc
)
#src md5 value(pg11.3)
SRCMD5=(
be4066f320806ddaa90c84006ed93a5e
)

# if ok return 0 ,else return 1
md5Check()
{
    cd ${toolPath}
    local value=`md5sum ${filePath} | awk '{print $1}'`
    if [ ${fileType} == "rpmdir" ];then
#       if echo "${RPMMD5[@]}" | grep -w ${value} &>/dev/null; then
#           echo "package md5 check success"
           return 0
##       fi
    fi

    if [ ${fileType} == "sourcedir" ];then
       if echo "${SRCMD5[@]}" |grep -w ${value} &>/dev/null; then
           echo "package md5 check success"
           return 0
       fi
    fi
    return 1

}


confCheck()
{
    if [ ! -e ${isopath} ];then
        echo "can not find iso:${isopath}"
       
        return 1
    fi
    if [ ${fileType} == "sourcedir" ] && [ ! -d ${prefixdir} ];then
        echo  "can not find prefixdir:${prefixdir}"
        return 1
    fi

    if [ ! -d ${datadir} ];then
        echo "can not find datadir:${datadir}"
        return 1
    fi

    if [ ! -d ${waldir} ];then
        echo "can not find waldir:${waldir}"
        return 1
    fi
    echo "conf check success"
    return 0

}

packageCheck()
{
    cd ${depDir}
   #gcc package check
   local gccpackage=`ls |grep -i gcc | wc -l`
   if [ ${gccpackage} -ne 1 ];then
      echo "can not find gcc package in ${depDir}"
      return 1
   fi
  # cmake package check
   local cmakepackage=`ls |grep -i cmake | wc -l`
   if [ ${cmakepackage} -ne 1 ];then
      echo "can not find cmake package in ${depDir}"
      return 1
   fi

   echo "dependency package check success"
   return 0
}

main()
{

    if [ ${compile_flag}x == "1x" ];then
        packageCheck
        if [ $? == 1 ];then
            echo "dependency package check failed"
            exit 0
        fi

        if [ ! -e ${isopath} ];then
            echo "can not find iso:${isopath}"
            exit 0
        fi

        md5Check
        if [ $? -eq 1 ]; then
            echo "package md5 check failed"
            exit 0
        fi
   else


         md5Check
         if [ $? -eq 1 ]; then
             echo "package md5 check failed"
             exit 0
         fi
         confCheck
         if [ $? -eq 1 ]; then
             echo "conf check failed"
             exit 0
         fi
 
    fi

}

main

echo "mysql check complete!!"
