#/bin/bash
#mysqlUninstall.sh conf
conf=$1
#fileType=$2

isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
db_password=`grep "db_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
#host=`grep "host" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
basedir=`grep "basedir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
datadir=`grep "datadir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
logdir=`grep "logdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
port=`grep "port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
depDir=${toolPath}/mysqlDep
cnfPath=${basedir}/my.cnf
installLog=${toolPath}/mysqlInstall.log

del=()
stopMysql()
{
    local line=`rpm -qa|grep mysql|wc -l`
    if [ ${line} -gt 0 ];then
        basedir="/usr/local/mysql"
    fi
    cd ${basedir}/bin
    ./mysqladmin -uroot -p${db_password} -h 127.0.0.1 -P ${port} shutdown &

    local line=`ps -ef |grep "mysqld" |grep -v "grep"|wc -l`
    local count=1
    while [ ${count} -le 5 ] && [ ${line} -gt 0 ]
    do
        sleep 5
        line=`ps -ef |grep "mysqld" |grep -v "grep"|wc -l`
        count=`expr ${count} + 1`
    done

    if [ ${count} -gt 5 ];then
        echo "mysql stop failed" >> ${installLog}
        echo "mysql stop failed"
        exit  0
    else
        sleep 5
        echo "mysql stop success" >> ${installLog}
        echo "mysql stop success"
    fi


}

Uninstall()
{
    local line=`rpm -qa|grep mysql|wc -l`
    if [ ${line} -gt 0 ];then
        local mysqlrpm=`rpm -qa |grep mysql`
        
        rpm -e ${mysqlrpm}
        basedir="/usr/local/mysql"
    fi


    local dataPrefix=$(dirname ${datadir})
    del=(${datadir} ${logdir} ${basedir} ${dataPrefix}/run ${dataPrefix}/tmp)
    echo "uninstall db,  delete the files: ${del[@]}"    
    rm -rf ${datadir}/* ${logdir}/* ${basedir}/*
    rm -rf ${dataPrefix}/run ${dataPrefix}/tmp
                 


}


main()
{


     local line=`ps -ef |grep "mysqld" |grep -v "grep"|wc -l`
    if [ ${line} -gt 0 ];then
       stopMysql
    fi    
    Uninstall

}

main
