#/bin/bash
#use : ./mysqlInstall.sh ${conf} ${func} ${filePath}

conf=$1
func=$2
filePath=$3

isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
db_password=`grep "db_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
#host=`grep "host" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
basedir=`grep "basedir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
datadir=`grep "datadir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
logdir=`grep "logdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
port=`grep "port" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
innodb_buffer_pool_size=`grep "innodb_buffer_pool_size" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
version=`grep "version" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`


toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
depDir=${toolPath}/mysqlDep
cnfPath=""
installLog=${toolPath}/mysqlInstall.log

installDepPackage()
{
    mount ${isopath} ${tempDir}
    cd /etc/yum.repos.d
    if [ ! -d /etc/yum.repos.d/backup ];then
        mkdir /etc/yum.repos.d/backup
    fi
    mv *repo ./backup
    touch local.repo
    echo "[local]" >> local.repo
    echo "name=local" >> local.repo
    echo "baseurl=file://${tempDir}" >> local.repo
    echo "gpgcheck=0"  >> local.repo
    echo "enabled=1" >> local.repo
    yum -y install expect net-tools bison ncurses ncurses-devel libaio libaio-devel openssl-devel gmp gmp-devel mpfr mpfr-devel libmpc libmpc-devel
    sleep 2
    umount ${tempDir}
}

installGcc()
{
    local requiredver="7.3.0"
    local currentver=`gcc -dumpversion`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "gcc match ,version:${currentver}"
        return 0
    fi

    cd ${depDir}
    local gcctar_name=`ls |grep -i gcc`
    local temp_gccdir=${depDir}/tempgcc_src
    mkdir ${temp_gccdir}
    tar xzvf ${gcctar_name} -C  ${temp_gccdir}
    cd ${temp_gccdir}
    local gccsrc_dir=`ls |grep -i gcc`
    cd ${gccsrc_dir}
    ./configure --prefix=/usr --mandir=/usr/share/man --infodir=/usr/share/info --enable-bootstrap --enable-shared --enable-threads=posix --enable-checking=release --with-system-zlib --enable-__cxa_atexit --disable-libunwind-exceptions --enable-gnu-unique-object --enable-linker-build-id --with-linker-hash-style=gnu --enable-languages=c,c++,objc,obj-c++ --enable-plugin --enable-initfini-array --disable-libgcj
    make -j 32
    make install
    sleep 2
    rm -rf ${temp_gccdir}
    cd ${depDir}
    local currentver=`gcc -dumpversion`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "install gcc success,gcc version is ${currentver}"  >> ${installLog}
        echo "install gcc success,gcc version is ${currentver}"
    else
        echo "gcc version error,the min version need ${requiredver},current ver is ${currentver}" >> ${installLog}
        echo "gcc version error,the min version need ${requiredver},current ver is ${currentver}"
        exit 0
    fi
}

installCmake()
{
    local requiredver="3.5.2"
    which cmake
    if [ $? == 0 ];then
      local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
      if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "cmake version match,cmake version is ${currentver}" 
        return 0
      fi
    fi

    cd ${depDir}
    local cmaketar_name=`ls |grep -i cmake`
    local temp_cmakedir=${depDir}/tempcmake_src
    mkdir ${temp_cmakedir}
    tar -xzvf ${cmaketar_name} -C ${temp_cmakedir}
    cd ${temp_cmakedir}
    local cmakesrc_dir=`ls |grep -i cmake`
    cd ${cmakesrc_dir}
    ./bootstrap
    make
    make install
    sleep 2
    rm -rf ${temp_cmakedir}
    cd ${depDir}
    local currentver=`cmake -version |grep "version"|awk '{print $NF}'`
    if [ "$(printf '%s\n' "${requiredver}" "${currentver}" |sort -V | head -n1)" == "${requiredver}" ];then
        echo "install cmake success,cmake version is ${currentver}"  >> ${installLog}
        echo "install cmake success,cmake version is ${currentver}"        
    else
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}" >> ${installLog}
        echo "cmake version error,the min version need ${requiredver},current ver is ${currentver}"
        exit 0
    fi


}

installMysqlSrc()
{
    cd ${toolPath}
    local temp_mysqldir=${depDir}/tempmysql_src
    mkdir ${temp_mysqldir}
    tar -xzvf ${filePath} -C ${temp_mysqldir}
    cd ${temp_mysqldir}
    local mysqlsrc_dir=`ls |grep -i mysql`
    cd ${mysqlsrc_dir}
    local boostdir=`ls boost`
    boostdir=${temp_mysqldir}/${mysqlsrc_dir}/boost/${boostdir}
    mkdir bld
    cd bld
    cmake .. -DCMAKE_INSTALL_PREFIX=${basedir} -DMYSQL_DATADIR=${datadir} -DSYSCONFDIR=/etc  -DWITH_INNOBASE_STORAGE_ENGINE=1 -DWITH_PARTITION_STORAGE_ENGINE=1 -DWITH_FEDERATED_STORAGE_ENGINE=1 -DWITH_ARCHIVE_STORAGE_ENGINE=1 -DWITH_BLACKHOLE_STORAGE_ENGINE=1 -DWITH_MYIASM_STORAGE_ENGINE=1 -DENABLED_LOCAL_INFILE=1 -DENABLE_DTRACE=0 -DDEFAULT_COLLATION=utf8mb4_general_ci -DWITH_EMBEDDED_SERVER=1 -DCMAKE_C_COMPILER=/usr/bin/gcc -DDOWNLOAD_BOOST=1 -DWITH_BOOST=${boostdir} -DFORCE_INSOURCE_BUILD=1
    make -j 32
    make install
    if [ -e ${basedir}/bin/mysqld ];then
        echo "install mysql success from source code" >> ${installLog}
        echo "install mysql success"
    else
        echo "install mysql failed from source code"  >> ${installLog}
        echo "install mysql failed"
        exit 0
    fi

}

installMysqlRpm()
{
   rpm -ivh ${filePath}
   basedir="/usr/local/mysql"
   

      
    if [ -e ${basedir}/bin/mysqld ];then
        echo "install mysql success from rpm package" >> ${installLog}
        echo "install mysql success"
    else
        echo "install mysql failed form rpm package"  >> ${installLog}
        echo "install mysql failed"
        exit 0
    fi


}


startMysql()
{
    cd ${basedir}/bin
    ./mysqld --defaults-file=${cnfPath} &

    local line=`ps -ef |grep "mysqld" |grep -v "grep"|wc -l`
    local count=1
    while [ ${count} -le 5 ] && [ ${line} -le 0 ]
    do
        sleep 5
        line=`ps -ef |grep "mysqld" |grep -v "grep"|wc -l`
        count=`expr ${count} + 1`
    done

    if [ ${count} -gt 5 ];then
        echo "mysql start failed" >> ${installLog}
        echo "mysql start failed"
        exit  0
    else
        sleep 5
        echo "mysql start success" >> ${installLog}
        echo "mysql start success"
    fi

}

stopMysql()
{
    cd ${basedir}/bin
    ./mysqladmin -uroot -p${db_password} -h 127.0.0.1 -P ${port} shutdown

    local line=`ps -ef |grep "mysqld" |grep -v "grep"|wc -l`
    local count=1
    while [ ${count} -le 5 ] && [ ${line} -gt 0 ]
    do
        sleep 5
        line=`ps -ef |grep "mysqld" |grep -v "grep"|wc -l`
        count=`expr ${count} + 1`
    done

    if [ ${count} -gt 5 ];then
        echo "mysql stop failed" >> ${installLog}
        echo "mysql stop failed"
        exit  0
    else
        sleep 5
        echo "mysql stop success" >> ${installLog}
        echo "mysql stop success"
    fi


}

createCnf()
{
#    if [ -f /etc/my.cnf ];then
#        mv /etc/my.cnf /etc/my.cnf.bak
#    fi
#    local cnfPath="/etc/my.cnf"
    cnfPath=${basedir}/my.cnf

    if [ ${func} == "sourceinstall" ]; then
    groupadd mysql
    useradd -g mysql mysql
    fi 

    touch ${cnfPath}
    local dataPrefix=$(dirname ${datadir})

    echo ${dataPrefix}

    if [ ! -d ${dataPrefix}/data ];then
        mkdir -p ${dataPrefix}/data
    fi

    if [ ! -d ${dataPrefix}/log ];then
        mkdir -p ${dataPrefix}/log
    fi


    if [ ! -d ${dataPrefix}/run ];then
         mkdir  ${dataPrefix}/run
    fi

    if [ ! -d ${dataPrefix}/tmp ];then
         mkdir  ${dataPrefix}/tmp
    fi
    chown -R mysql:mysql ${dataPrefix}
    chown -R mysql:mysql ${logdir}

    echo "[mysqld]" >> ${cnfPath}
    echo "basedir=${basedir}" >> ${cnfPath}
    echo "datadir=${datadir}" >> ${cnfPath}
    echo "log-bin=${logdir}/binlog"  >> ${cnfPath}
    echo "innodb_log_group_home_dir=${logdir}" >> ${cnfPath}
    echo "tmpdir=${dataPrefix}/tmp" >> ${cnfPath}
    echo "socket=${dataPrefix}/run/mysql.sock" >> ${cnfPath}
    
    echo "port=${port}" >> ${cnfPath}
    echo "user=root" >> ${cnfPath}
    echo "innodb_buffer_pool_size=${innodb_buffer_pool_size}" >> ${cnfPath}	
    
    cat  >>  ${cnfPath} << EOF

default_authentication_plugin=mysql_native_password

max_connections=2000
back_log=2048
performance_schema=OFF
max_prepared_stmt_count=128000

#file
innodb_file_per_table
innodb_log_file_size=1024M
innodb_log_files_in_group=16
innodb_open_files=10000
table_open_cache_instances=64
table_open_cache=10000

#buffers
innodb_buffer_pool_instances=16
innodb_log_buffer_size=2048M

#tune
sync_binlog=1
innodb_flush_log_at_trx_commit=1
innodb_use_native_aio=1
innodb_spin_wait_delay=180
innodb_sync_spin_loops=25
innodb_flush_method=O_DIRECT
innodb_io_capacity=30000
innodb_io_capacity_max=40000
innodb_lru_scan_depth=9000
innodb_page_cleaners=16

#perf special
innodb_flush_neighbors=0
innodb_write_io_threads=24
innodb_read_io_threads=16
innodb_purge_threads=32
innodb_adaptive_hash_index=OFF
ssl=0
EOF


}

initMysql()
{
  # groupadd mysql
  #  useradd -g mysql mysql

    cd ${basedir}/bin
    ./mysqld --defaults-file=${cnfPath} --initialize --basedir=${basedir} --datadir=${datadir} --user=mysql 2>&1 | tee -a ${installLog}
    local passwd=`grep "temporary password" ${installLog} | awk '{print $NF}'`
    
    startMysql
    
    echo ${passwd}
#    echo ${#passwd}
#    echo " -uroot -p${passwd} -h 127.0.0.1 -P ${port}"
    ./mysql -uroot -p${passwd} -h 127.0.0.1 -P ${port} --connect-expired-password -e " 
    alter user 'root'@'localhost' identified by '${db_password}';
    create user 'root'@'%' identified by '${db_password}';
    grant all privileges on *.* to 'root'@'%';
    flush privileges;
    quit"
    
    ./mysql -uroot -p${db_password} -h 127.0.0.1 -P ${port} -e "show databases"
     
    if [ $? == 0 ];then
        echo "init mysql success" >> ${installLog}
        echo "init mysql success"
    else 
        echo "init mysql failed" >> ${installLog}
        echo "init mysql failed"
	exit 0
    fi

}

rpmBuild()
{
    mkdir -p ${tempDir}/rpmbuild/{BUILD,RPMS,SOURCES,SPECS,SRPMS}
    CPUS=`cat /proc/cpuinfo |grep process |wc -l`
    filename=`echo ${filePath} | awk -F '/' '{print $NF}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
    cd ${toolPath}
    cp ${filePath} ${tempDir}/rpmbuild/SOURCES
  #  	wget -O ~/rpmbuild/SOURCES/mysql-$1.tar.gz https://downloads.mysql.com/archives/get/file/mysql-boost-$1.tar.gz --no-check-certificate > /tmp/wget.log 2>&1
	echo """name: mysql
Version: ${version}
Release: 1.el7
License: Copyright (c) 2000, 2019, Oracle and/or its affiliates. All rights reserved. Under GPLv2 license as shown in the Description field.
URL: http://www.mysql.com/
Group: applications/database
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
Packager:tsdbtool
Autoreq: no
Source: ${filename}
prefix: /usr/local/mysql
Summary: A very fast and reliable SQL database server
%description
The MySQL(TM) software delivers a very fast, multi-threaded, multi-user,
and robust SQL (Structured Query Language) database server. MySQL Server
is intended for mission-critical, heavy-load production systems as well
as for embedding into mass-deployed software. MySQL is a trademark of
Oracle and/or its affiliates

The MySQL software has Dual Licensing, which means you can use the MySQL
software free of charge under the GNU General Public License
(http://www.gnu.org/licenses/). You can also purchase commercial MySQL
licenses from Oracle and/or its affiliates if you do not wish to be bound by the terms of
the GPL. See the chapter "Licensing and Support" in the manual for
further info.

The MySQL web site (http://www.mysql.com/) provides the latest news and
information about the MySQL software.  Also please see the documentation
and the manual for more information.

This package includes the MySQL server binary as well as related utilities
to run and administer a MySQL server.
%define MYSQL_USER mysql
%define MYSQL_GROUP mysql
%define _topdir ${tempDir}/rpmbuild
%define __os_install_post %{nil}
%define __debug_install_post %{_rpmconfigdir}/find-debuginfo.sh %{?_find_debuginfo_opts} "%{_builddir}/%{?buildsubdir}" %{nil}

%prep
%setup -q -n %{name}-%{version}
%build

cmake . -DCMAKE_INSTALL_PREFIX=/usr/local/mysql -DMYSQL_DATADIR=/data/mysql/data -DSYSCONFDIR=/etc -DWITH_INNOBASE_STORAGE_ENGINE=1 -DWITH_PARTITION_STORAGE_ENGINE=1 -DWITH_FEDERATED_STORAGE_ENGINE=1 -DWITH_ARCHIVE_STORAGE_ENGINE=1 -DWITH_BLACKHOLE_STORAGE_ENGINE=1 -DWITH_MYISAM_STORAGE_ENGINE=1 -DENABLED_LOCAL_INFILE=1 -DENABLE_DTRACE=0 -DDEFAULT_CHARSET=utf8mb4 -DDEFAULT_COLLATION=utf8mb4_general_ci -DWITH_EMBEDDED_SERVER=1 -DCMAKE_C_COMPILER=/usr/bin/gcc -DDOWNLOAD_BOOST=1 -DWITH_BOOST=./boost/ -DFORCE_INSOURCE_BUILD=1
make -j${CPUS}
%install
make DESTDIR=\$RPM_BUILD_ROOT install
cp /usr/lib64/libatomic.so.1.2.0 \$RPM_BUILD_ROOT/usr/local/mysql/lib
cp /usr/lib64/libstdc++.so.6.0.24 \$RPM_BUILD_ROOT/usr/local/mysql/lib
%clean
rm -rf \$RPM_BUILD_ROOT
rm -rf \$RPM_BUILD_DIR/*
%files
%defattr(-, %{MYSQL_USER}, %{MYSQL_GROUP})
%attr(755, %{MYSQL_USER}, %{MYSQL_GROUP}) %{prefix}/*
%pre
if ! id %{MYSQL_USER} > /dev/null 2>&1;then
	groupadd %{MYSQL_GROUP}
        useradd  -g %{MYSQL_GROUP} %{MYSQL_USER}
fi
%post
if [ -f %{prefix}/support-files/mysql.server > /dev/null 2>&1 ]  && [ ! -f %{_initddir}/mysql > /dev/null 2>&1 ];then
	cp %{prefix}/support-files/mysql.server %{_initddir}/mysql
	chmod +x %{_initddir}/mysql
	chkconfig --level 2345 mysql on
fi
if [ ! -f /usr/lib64/libatomic.so.1 ];then
        cp -f /usr/local/mysql/lib/libatomic.so.1.2.0 /usr/lib64/
        ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
else
        ver1=\`ls -l /usr/lib64/libatomic.so.1|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver11=\`echo -e \"\${ver1}\\n1.1.99\"|sort -V|tail -1\`
        if [ \"\${ver11}\" = \"1.1.99\" ];then
                cp -f /usr/local/mysql/lib/libatomic.so.1.2.0 /usr/lib64/
                rm -f /usr/lib64/libatomic.so.1
                ln -s /usr/lib64/libatomic.so.1.2.0  /usr/lib64/libatomic.so.1
        fi
fi
if [ ! -f /usr/lib64/libstdc++.so.6 ];then
        cp -f /usr/local/mysql/lib/libstdc++.so.6.0.24 /usr/lib64/
        ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
else
        ver2=\`ls -l /usr/lib64/libstdc++.so.6|awk -F'.' '{print \"\"\$6\".\"\$7\".\"\$8\"\"}'\`
        ver22=\`echo -e \"\${ver2}\\n6.0.23\"|sort -V|tail -1\`
        if [ \"\${ver22}\" = \"6.0.23\" ];then
                cp -f /usr/local/mysql/lib/libstdc++.so.6.0.24 /usr/lib64/
                rm -f /usr/lib64/libstdc++.so.6
                ln -s /usr/lib64/libstdc++.so.6.0.24  /usr/lib64/libstdc++.so.6
        fi
fi
%preun
if [ -f %{_sysconfdir}/my.cnf ];then
	mv %{_sysconfdir}/my.cnf %{_sysconfdir}/my.cnf.rpmold
fi
if [ -f %{_initddir}/mysql ];then
	mv %{_initddir}/mysql %{_initddir}/mysql.rpmold
fi
%postun
rm -rf %{prefix}
userdel -r %{MYSQL_USER} >/dev/null 2>&1
%changelog""" > ${tempDir}/rpmbuild/SPECS/mysql.spec
        echo "begin to build rpm,it will takes about 30 min"
	rpmbuild -bb  ${tempDir}/rpmbuild/SPECS/mysql.spec > /tmp/rpm.log 2>&1
	if [ $? -eq 0 ];then
		echo "compiler success"
	else
                echo "compiler failed"
		tail -10 /tmp/rpm.log
                exit 1
	fi
        cp ${tempDir}/rpmbuild/RPMS/aarch64/* ${toolPath}
        

}
main()
{

    rm -rf ${installLog}
    rm -rf ${tempDir}
    mkdir ${tempDir}
    if [ ${func} == "sourceinstall" ]; then
        installDepPackage
        installCmake
        installGcc
        installMysqlSrc
        createCnf
        initMysql
    fi
    if [ ${func} == "rpminstall" ]; then
        
        installMysqlRpm
        createCnf
        initMysql
    fi

    if [ ${func} == "compile" ];then
       installDepPackage
        installCmake
        installGcc
        rpmBuild
    fi      

}


main
echo "-----success------"
echo "mysqlInstall.sh complete!!" >> ${installLog}



