#!/bin/bash
#mongodbUninstall.sh conf
conf=$1

os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_server=`grep "config_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_server_num=`grep "config_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
config_db_prefix_dir=`grep "config_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_server=`grep "router_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_server_num=`grep "router_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
router_db_prefix_dir=`grep "router_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_server=`grep "shard_server," ${conf} | awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_server_num=`grep "shard_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_db_prefix_dir=`grep "shard_db_prefix_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
shard_num=`grep "shard_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
replica_num=`grep "replica_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
#mkdir ${tempDir}
depDir=${toolPath}/mongodbDep
cnfPath=""
installLog=${toolPath}/mongodbInstall.log
shard_server_list=(`echo ${shard_server} |tr ';' ' '`)
router_server_list=(`echo ${router_server} |tr ';' ' '`)
config_server_list=(`echo ${config_server} |tr ';' ' '`)
shard_db_prefix_dir_list=(`echo ${shard_db_prefix_dir} |tr ';' ' '`)

Uninstall()
{
    local line=`rpm -qa |grep mongo | wc -l`
    local mongorpm=""
    if [ ${line} -gt 0 ];then
        mongorpm=`rpm -qa |grep mongo`
        prefixdir="/usr/local/mongo"
    fi
    if [ ${#config_db_prefix_dir} -eq 0 ];then
        echo "can not find config_db_prefix_dir,check config file"
        exit 1
    fi 

    if [ ${#router_db_prefix_dir} -eq 0 ];then
        echo "can not find router_db_prefix_dir,check config file"
        exit 1
    fi

    if [ ${#shard_db_prefix_dir} -eq 0 ];then
        echo "can not find shard_db_prefix_dir,check config file"
        exit 1
    fi
    local mongorpm=`rpm -qa |grep mongo`
    for((i=0; i<${config_server_num}; i++))
    do
        ssh -tt ${os_root_user}@${config_server_list[${i}]} <<-EOF
pgrep mongod | xargs kill -9
rm -rf ${config_db_prefix_dir}/*
rm -f /tmp/.s.PGSQL*.lock
sleep 1
exit
EOF

    done

    for((i=0; i<${router_server_num}; i++))
    do
        ssh -tt ${os_root_user}@${router_server_list[${i}]} <<-EOF
pgrep mongos | xargs kill -9
rm -rf ${router_db_prefix_dir}/*
rm -f /tmp/.s.PGSQL*.lock
sleep 1
exit
EOF
    done

    local sharddirstr=""
    for((i=0; i<${shard_num}; i++))
    do
        sharddirstr="${sharddirstr} ${shard_db_prefix_dir_list[${i}]}/*"
    done

    for((i=0; i<${shard_server_num}; i++))
    do
        ssh -tt ${os_root_user}@${shard_server_list[${i}]} <<-EOF
pgrep mongod | xargs kill -9
rm -rf ${sharddirstr}
rpm -e ${mongorpm}
rm -rf ${prefixdir}/*
rm -rf ${depDir}/temppy_src ${depDir}/tempmongo_src
rm -f /tmp/.s.PGSQL*.lock
sleep 1
exit
EOF

    done
}

Uninstall


