#/bin/bash
#use:greenplumUninstall.sh ${conf}
conf=$1


isopath=`grep "isopath" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}' `
os_root_user=`grep "os_root_user" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
os_root_password=`grep "os_root_password" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
prefixdir=`grep "prefixdir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

master_server=`grep "master_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
master_dir=`grep "master_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

standby_server=`grep "standby_server" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
standby_dir=`grep "standby_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

seg_server=`grep "seg_server," ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_server_num=`grep "seg_server_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_data_dir=`grep "seg_data_dir" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_mirror_data_dir=`grep "seg_mirror_data" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`
seg_dir_num=`grep "seg_dir_num" ${conf} |awk -F ',' '{print $2}' | awk '{gsub(/^\s+|\s+$/,"");print}'`

seg_server_list=(`echo ${seg_server} |tr ';' ' '`)
seg_data_dir_list=(`echo ${seg_data_dir} |tr ';' ' '`)
seg_mirror_data_dir_list=(`echo ${seg_mirror_data_dir} |tr ';' ' '`)

toolPath=$(dirname $(readlink -f $0))
tempDir=${toolPath}/temp
#mkdir ${tempDir}
depDir=${toolPath}/greenplumDep
cnfPath=""
installLog=${toolPath}/greenplumInstall.log

all_server="${seg_server};${master_server};${standby_server}"
all_server_list=(`echo ${all_server} |tr ';' ' '`)
#deduplication
all_server_list=(`echo ${all_server_list[@]} | sed 's/ /\n/g' | sort | uniq`)
all_server=`echo ${all_server_list[@]} | sed 's/ /;/g'`


stopgp()
{
    su - gpadmin <<-EOF
gpstop
exit
EOF

}

delstandby()
{
    local line=`ssh ${os_root_user}@${standby_server} "rpm -qa |grep gpdb |wc -l"`
    if [ ${line} -gt 0 ];then
        prefixdir="/usr/local/gpdb"
        rpmname=`ssh ${os_root_user}@${standby_server} "rpm -qa |grep gpdb"`
    fi

    ssh -tt ${os_root_user}@${standby_server} <<-EOF
pgrep postgre | xargs kill -9
rm -f /tmp/.s.PGSQL*.lock
rpm -e ${rpmname}
rm -rf ${standby_dir}
rm -rf ${prefixdir}
exit
EOF

}
delseg()
{
    local datadir_str=""
    for datadir in ${seg_data_dir_list[@]}
    do
         datadir_str="${datadir_str} ${datadir}"
    done
    local mirrordir_str=""
    for mirrordir in ${seg_mirror_data_dir_list[@]}
    do
         mirrordir_str="${mirrordir_str} ${mirrordir}"
    done
    
    for serverip in ${seg_server_list[@]}
    do
         local line=`ssh ${os_root_user}@${standby_server} "rpm -qa |grep gpdb |wc -l"`
         if [ ${line} -gt 0 ];then
            prefixdir="/usr/local/gpdb"
            rpmname=`ssh ${os_root_user}@${standby_server} "rpm -qa |grep gpdb"`
         fi

        ssh -tt ${os_root_user}@${serverip} <<-EOF
pgrep postgre | xargs kill -9
rm -f /tmp/.s.PGSQL*.lock
rpm -e ${rpmname}
rm -rf ${datadir_str}
rm -rf ${mirrordir_str}
rm -rf ${prefixdir}
exit
EOF
    done
    echo "del seg"

}
delmaster()
{
    local line=`ssh ${os_root_user}@${standby_server} "rpm -qa |grep gpdb |wc -l"`
    if [ ${line} -gt 0 ];then
        prefixdir="/usr/local/gpdb"
        rpmname=`ssh ${os_root_user}@${standby_server} "rpm -qa |grep gpdb"`
    fi

    ssh -tt ${os_root_user}@${master_server} <<-EOF
pgrep postgre | xargs kill -9
rm -f /tmp/.s.PGSQL*.lock
rpm -e ${rpmname}
rm -rf ${master_dir}
rm -rf ${prefixdir}
exit
EOF


}

main()
{
#   gpstop
   delstandby
   delseg
   delmaster
}
main
echo "uninstall pg success"
