proc create_icon_images { iconset } {
switch $iconset {
iconicgray {
dict set icons new {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQEylVTVIwAAAFRJREFUOMvt0jEOgDAMQ1EHcdJ/
EXoSXxUmJhraKgsDnqMnK0kApzqxHZIENNtNSTaNcwAl4BWZBVJkBegiq8AD2UfT9zWqS0wT2R/M
Nis3+IEvABefGhi1jFm7RgAAAABJRU5ErkJggg==
}

dict set icons open {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQMJFmlehQAAADJJREFUOMtjTEpK+s+ABcybN4+R
gQjAxEAhYMTlAmIBxS4YeDDwYTBqwLAx4CQF+o8BAHQICfOLv0ssAAAAAElFTkSuQmCC
}

dict set icons save {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQUq4lSIcQAAAG1JREFUOMvtkbsJgEAQBccPaGRm
KYL1vMK2HLEWQU39gBiooIHBnWLkwIYz8NhA0gAkuDGaWQoQesicnZCH/IEtUHt4FW8RSMqB3tHL
zKw7JjTA7HitpPjzLxRA+SQQ7XchdgjUdxMmj+kzsACsPdserlKSBpYAAAAASUVORK5CYII=
}

dict set icons copy {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDMkjTJeNAAAAGdJREFUOMtjYMABkpKSTiYlJR1n
IABY8MiZMRABGJOSkj4xMDDwzps3jxFq8ycGBgZeNHWf582bxweV/4/MZ8KimBeLRTjVYHgB5hJi
ARMDhYAFKdT/k2MAxS4YNWDYGPCZDH0fYQwAHkgYTiwv0CwAAAAASUVORK5CYII=
}

dict set icons cut {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAA3XAAAN1wFCKJt4AAAAB3RJTUUH4QcRCDsP6VctfAAAAWhJREFUOMt90r1rFHEQxvGPORFE
SGpRUsSXzmIbsRGLawQtLYPFYCwCHhYWViktohCbWMkQxMJO/RssNNUWVtFo0oiFnSJBwWAzJMvd
bQYGdr/zzLP7e3bpVETMRcS6noqI9YiY67KZMc1lLEfEcMryEMul6TXYwT7WImLQWR5grWY7vQaZ
uY0NXMJSZ7RUbKM0B3VsyquewWf8xvnC2ziFC5n5rasfjBu0bfuraZqTuI4TuIYhVjPz7bj+eE/g
q7iLe3X/o9hEDabBtm3/NE2zh5uleZiZ76ZpZ/TXVs+1I0PsfLa2koePaDLz35EGEXERd3Aai/hS
o3N4ie94npmfJo4QETewiQVcLfymWrEFbJZ2IoNnWMnMWxgVe10No5qtlPbQICJmMY9Xxc9iF++r
d4spzXztHPwHfyvpUUR8xWPcz8z9esAjPI2IvTrGVu0chhgRVyqoWTzIzBdjAd/GE/zEYmZ+gP9j
J3L2egtT0gAAAABJRU5ErkJggg==
}

dict set icons paste {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDkinr4TiwAAADhJREFUOMtjTEpK+s9AAWBiGPKA
kdgwmDdvHuMwDYMhFAujKREzRSYlJZ1hYGD4Q0kY/GFgYPgLAF8pET4RBXzxAAAAAElFTkSuQmCC
}

dict set icons search {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDMIv+oy1wAAATZJREFUOMuVkz9Lw1AUxX+xLiru
gmvQ1eCss2BnLYgiF4RCiRX8BO7+VxAdbgUhiygO/RhicBJRXBT8AIqDQ+JyC7ehxfQsJy9wfjl5
774AJxGZBGKgCoTAMPAKtIEjVX2noMCFV4BzYIze+gEaqnrpXw658JWFr4F5YBwYAeaAW2AUaInI
elcDq/1s4VhVT3t9XkS2gV1rMq2qH50GsYWTfmEAVd0D7qzJlv+Fqj0f8r8OzBc9IAQy4KEE4N48
7NrEAZSZ5x7wYj5TAjBr/uQBbXtulgBsmt94wAnwDayKyEa/pIg0gCVbfnVNoojUgMTWCXBsmxpY
7Saw7Hi5TeWZH+UacGETWEY5UA8KNSfcZZqyBp3L9AnsF07uNxjkDEVkDWg5SFYZBJCm6WMURW/A
AlABdv4AxctR+njihTcAAAAASUVORK5CYII=
}

dict set icons ctext {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDco4OjXGwAAAHtJREFUOMvNkssNwCAMQ03UvaCr
ZJJOklUKm/USIT4FwqnNJQJHPMcC+LqcZYiZA4AbQBKRUGpkBF1Nz3WsCKp51SIzRz2fIhJpRXjR
qu4M9E4rXdAmvbunRfJ599EcWSgzZ6SvJwBeqVN6q5El6Zkzt/PrRhlgY/cf1gNBmEd+ii9ksQAA
AABJRU5ErkJggg==
}

dict set icons test {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQYEFa/WfQAAAIxJREFUOMvtkssNg0AMRGdXFLFQ
QEQbaWUKm1agDSggoYKgXJIcMJJBOezClZEs2Yd58i+Q/AAIOKY5OvPDokSxcua75T2AOpvgC0mj
gZ6lgAZAR/ImaTDIVNyBU/ZSNzuQNJJsAXQAko31F0byu+8g7M05CivJzZwKzviuXJGOfFLESV2A
5ZHmE6DXD1ozIzt7SlO+AAAAAElFTkSuQmCC
}

dict set icons lvuser {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDgJKxnbigAAAUZJREFUOMul0j9PVUEQBfDffT5o
SCwksfILUF7BYCxoiI1GIgWV3XY2EGwICYnEigZIDEI3DZ/AhMKCksLC8Eo6KxpjghUNf8RmN3lu
rslLPM3snjlzdndmGyMgpbSM97jCh4g4KLlmhOJ5HFf0q4g4gn4lXsUGbvJJn/AV53g0JH2HI+gN
FS9hBw/wEHsppdcRcYmP1Q2my6I3RK52vKBwXyq+6TJ43GEwk+P3ij/tMrjrMCgn/a743S6D0w6D
bznex09cYCUiPhfB8BS28awy2IaI+JEbWxo+hnXs3yvkYDA4a9v2F57gEmsRcViNeaJt2+c4xBtM
NSmlSbzFVkTcVAV9rOEgIi5SSvtZW3DdR2ABL1NKmzjJDZ3DJmbzNBZRG4z18SJvnnbMu6BozupE
r/7O/8B4buZtnRil+C9ERFPf4L/wB3mtVmtln4SNAAAAAElFTkSuQmCC
}

dict set icons runworld {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDM4mTMCewAAAFdJREFUOMtjYBg0ICkp6UBSUpID
qfoYkQz4D2UeZGBgaJg3b94Bcg1gIMUgfAYQZRAxBuA1iBQDsBrERGnssZCgFqsXWMjVSIwBREUj
C7kasRlAksbBAwAC3DSvT7HthQAAAABJRU5ErkJggg==
}

dict set icons rungreen {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCgwSGdI1/wAAAFNJREFUOMtjYBg84AzDAYYzDA6U
GPAfikkyiBHFAFRwkIGBoYHBhOEAuQYQZRAxBuA1iBQDsBrERGnksZCgFqsXWMjVSIwBREUjC7ka
aZCUBwoAAAjHJEmw0QWlAAAAAElFTkSuQmCC
}

dict set icons boxes {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQET2T3FfQAAAGJJREFUOMvt0jEKwzAMRuHPrk+q
EzT3CDmCT+rSLjFk6VClkCVvkkAPiR+ViFjxxMNvvLDVpGx3ljbl3nuBiHgf+2/sc606SZkbs5y+
oM0imYE7gz9lMJKvDKNiw8jIWF3OBy+zJzqS//nPAAAAAElFTkSuQmCC
}

dict set icons pencil {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQUVVDKlTAAAAKhJREFUOMvVkUsOgkAQBYsJV/CC
7w7+PzAIivEOfVODGzADAhFY2bvX6ap0z8CMkrSW9ACIZsBboKxj7ibC+wAGeLkJ8BG4BS1vZqkb
GE4kpUE+A3kX7n0DSRfAN4NABaR98JdA0gm4jlzSglsCSQegmAJ/BJJ2wD3oJ/Xq2RgMEEvadODM
zLJa7IBoCAaIgVWQCzNLmmBm/tc/fkoq+cuKJFVLBG7pBm9kx0HTW1IhWQAAAABJRU5ErkJggg==
}

dict set icons autopilot {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDIHNk4eBwAAAMBJREFUOMutk7ENwjAQRV9CkLIG
aancUTIALHEDQAkDUEAJA1yZGins4Y4SRoAyXWiMZBkssJJfWr5/z993GU4i0pEgVc0AcnqqiDnH
FJIOR/Crc0y5h7YUkUWqQeaKS+AKdMBUVdsvb2+AsMHlTbAFJkAFbCLN1oBv3AKrkYhUQO3lMTPG
1Nbap19trX0YY8bA3B3tVPWcA0eg9O6WwClCsQfuwA04fPzvP9MYhl2kpq6qTa9BCkmH34XUrexN
8AJ/eTvs9CDvkQAAAABJRU5ErkJggg==
}

dict set icons distribute {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQIVG3MziwAAANJJREFUOMvNkj1uAkEMhb8NI7gG
Veq0KSgCZW7xGlJyAX4iUUUIcYJ3C5o0OU56GoQEIs0OWq08IKjyOo/12c/2VJJWwATo0JDtikCS
FrYXOX6K4BuaS/rMQcrwlY4vwAcwBPr180xSZXuWSm0k9YANMAai4lNJVSrAXWALjG6Mcyg5+GrA
p1Yu72tqe5mC7s/AG/AO/Njet/LnDOcltvUKDGzvCu4ucD5jW99XYJpwWMD27x1/InRQOuu5nv+x
AiWl+kydqHqgY+RgHSUK8Ip/pz+3WkLzSd4rKQAAAABJRU5ErkJggg==
}

dict set icons benchmark {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQQwBi1ASgAAAWhJREFUOMuV071rVUEQBfBfTKqo
WFoErKxEhWe0Coj2NiJ+FYoMVuIn+G+oAdFCdNKJEBQfBAQrC7UQ8RVqEbS2swlWGnkWTmDf5QZ0
4LJzZ/ecmTk7O6VjEbGuxzJzpi/eF5z2H7alk30XFvG1Cb/HQs+5yQoi4gLuYbaTZD9W68w0LuHp
RAURcR5LBX6OI9iObZjPzO8RsRNDvM7MbxsEUxExVxm24mZm3uoRdgFPcDkzh10Nrhb42Sbg63iF
25k5jIi5iDjcanCs/MUOcBYPcRb3M/NOROzDB3zEgQ2C3Y3arb0s9V9Ulep2ZrCnbWFc/rhD8Atv
cSozf3f2xm0LX7AX83jTTN7Rnrk5WOtqW8FK+df+YfBu1LrSEtzFD5yMiCubIes2jmOtMH/noDbP
4HH9L9eNbIh6qDKfqN5PZ+byBEFD8qAmsM/WcLEFT7y80Wj0aTAYLOEndtS3js94hHOZ+a7L+gcC
QG0/cZGu3wAAAABJRU5ErkJggg==
}

dict set icons driveroptim {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQAaufpMmAAAAIdJREFUOMvNk8sNgzAQRJ+BFqAV
RBlpYST3FHHYehCdJBRBLliKIgN2LCTmZu2+8X5sx48kPYAn0HGsBfBVJJACA7TAGDMIcA8MJyZd
sxcxs3lr6dCholDFBs1Zgpm5SytwkXewpoChsvIhSlpTb735GiX1QP2PwbJ9jCmDe3234IF3JuzD
4QPzJRoy6DDmoAAAAABJRU5ErkJggg==
}

dict set icons vuseroptim {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDgJKxnbigAAAUZJREFUOMul0j9PVUEQBfDffT5o
SCwksfILUF7BYCxoiI1GIgWV3XY2EGwICYnEigZIDEI3DZ/AhMKCksLC8Eo6KxpjghUNf8RmN3lu
rslLPM3snjlzdndmGyMgpbSM97jCh4g4KLlmhOJ5HFf0q4g4gn4lXsUGbvJJn/AV53g0JH2HI+gN
FS9hBw/wEHsppdcRcYmP1Q2my6I3RK52vKBwXyq+6TJ43GEwk+P3ij/tMrjrMCgn/a743S6D0w6D
bznex09cYCUiPhfB8BS28awy2IaI+JEbWxo+hnXs3yvkYDA4a9v2F57gEmsRcViNeaJt2+c4xBtM
NSmlSbzFVkTcVAV9rOEgIi5SSvtZW3DdR2ABL1NKmzjJDZ3DJmbzNBZRG4z18SJvnnbMu6BozupE
r/7O/8B4buZtnRil+C9ERFPf4L/wB3mtVmtln4SNAAAAAElFTkSuQmCC
}

dict set icons mode {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDEHHWNNxAAAAEJJREFUOMtjTEpK+s+AB8ybN48R
nzwTA4VgCBmQlJT0H1t4DYMwYCEUz/jChDouwGUy3cKAkVyNVAsDRmJtolkYAADNNRLbLJ278QAA
AABJRU5ErkJggg==
}

dict set icons option {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQoaQxWkEgAAAVRJREFUOMuV071qVVEQBeDvXMQo
RILvIIJVhEjARGz9eQFBlODUsbMSEQyksRJC2mkk4huIloJcJZGAnSD4CAoiciOIzRzYOZwLOrBh
ftbArDWzO3MsIlbxocLVzNwfw02ahjMRsdzUNsf8iLgYEYt93FVyEa+xhnd4g4dYKNwM27iBy3iL
m5n580QBLlQzrNdrbQFbTXwV53E4geK3799tmpmHxzTAq8afFe+zWCp/NobtImIF93ELp3rRMnN3
sJVN7FT4Cy+xO8EBNppm2BsZ+3njn8Y9HEzmcPwzkuvm3cGVGud3k787gt1o/CO8wHrXcHyCx42I
D2rsrpqf4mTVH2Xm9nAL1wZ738F3fMOzphmuDy9xpcT8H1vOzE/9BF+aj/O+ru5owHmrObYpvh5T
NiKWcC4zP1a8h9v9WjPzTuUv4XNm/pi7mgL2HwvWMnM6hvsLJ5ZgxP4SaF4AAAAASUVORK5CYII=
}

dict set icons driveroptlo {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDEtxtiEEgAAAF1JREFUOMul08sNACEIBFAypdLI
aiPU6n3DZ0Y5QuaFSDT7lbsvEwpJ71MQFH0aQTOjEAzzEQGxZYuAfKsSgXCxFFEAe91gR8T1BmmY
BcowA7ThCRjDHUCF01K/8wEN9SOOk+b/LwAAAABJRU5ErkJggg==
}

dict set icons tick {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCgsUv/AGDQAAAJxJREFUOMvV0ssJwlAQBdBjSCEW
4VosQoMKLgTLEtwIqUWYIiK24W9h/BFjYnbOcnjn8pgZ/qtCImyFWVe8ES7CUVhArzVmjeVL94x5
0hHDAbukfJQKuTBuifcYGSgSIUWOKXJh0hbfZhAPfK8TVhg24XvAuPxB2jCNCn5uoTnkI35fY31I
La7eQTXkK67be1ZeWiH0u9581h3/WFf8WD2JUd29bwAAAABJRU5ErkJggg==
}

dict set icons cross {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRChUmo2ZoUgAAAR9JREFUOMuN07tNA0EQxvHf2QYa
oABiIhfggAZAAmGbh0FARFE8AgIkwEJCNAHRlAACF8Gb4BZrOewTk+3c9/9mbnYWBK3gPFhXE0Ej
OAt6ebIVXAZfwVvQrYFPk+492IYiOMdGpv3ATrvMj2EcYy/TfWKrgSHesw9NZZu7GXxSgeEJd0US
dZUVm5UKh+hIZlk8YqnNQ5G1uYmzismkGMOU7YH0z3up8r9gKCZM+yANrBojdHL4VwfZwDpTqs9j
sZpsVOAj7E8xmMN1sPzHoAYe4SU7z2IYrI4NsiXZnzCwDtbwmuVncPGzzkWUVzeom3awgqsE5xu7
1cBtOky9qjY36Fc29hn3PwMcBB/BQ7BQ8xp76SH91QX9OrhiMtZ9A1/cZEkDQzltAAAAAElFTkSu
QmCC
}

dict set icons clock {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDQVk63IyQAAAWdJREFUOMuN079OVFEQBvDfvVGh
MNr4ANKZEN1EfABdGt5BqkkU1I7wGGJCsa420+kjQANPoOKfAHbEWFja6hojNrPJzc2CTnJykjnf
d74z881p9CIiBljHENcr/QX7eJGZn7r4pkOcxzYedPO9OMUYG5k5gbZD3sVD/MRT3MZ8rSU8wwSP
sVMcF+rmbdzFV6xk5uee8gEOIiJLaIgtPGmq5velvDQlR0SDH/idmZc7pS7iHS5h0FbDGoy6ypl5
irkqQSd/hOfFWWvrOfDa/8er2pfbjlXHZ4CbiLjSy02xC+0/lD6WU3sRcW0WoK0hgcUZ50N8wNVq
mh72pK0Jg/t9dmZ+xwruZea3ztFq7ftNRNwqlQnuVJfPjIi4iTe4iEFbsz0uu3bL5/PIO2XvKDMP
p5O4gRtV89uIGJdVx52aV2tm5rCHzVmfaQuPzvlMfzDCZmb+MgtYz1zDMham3a5mv8zMwy7+L/Bx
cwJlXD78AAAAAElFTkSuQmCC
}

dict set icons running {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCC0ccXHZdQAAAPJJREFUOMuV0jFKA1EQxvHfbvZI
AcXCS4iCSkJ8WEsMCFoIFim0EMUDjKJoIV7A1iKVBwqi0SbCuiS763Qz8/1n3puZTIOllDYwRBcX
EXFWzmcN8CVGc/c8Ik6qmryh86gUOl2ky2seMNTC6gp0W8znqK7ArAE+xrio0bxjveRPU0rlfAeT
Ykn1LaxVwp0F0qt8AbyNJxQNI7iOiJe8Au/iodLtE2+Y4gMTbEbE4Z9DSin1cFfZzBd2IuK5do0p
pcESuFcHQ5ZS6uO2As/Qj4jHNod0gxWsluC9NvBvgWw+tA6+sR8R91pagQO8zv88+A8MP/jxRmqF
usQwAAAAAElFTkSuQmCC
}

dict set icons oneuser {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDgymhIyrgAAAPFJREFUOMul0jFKA0EYxfFfooUo
pBC8gY1aLYIIWukRAhZimm0EwcbGKwTBTiy/SkECXsIijUoqcw6xEC1EmynCsFlW9sEU8+Z9/xmY
11GhsixXcY0+fvGIi4h4z7OdiuEljFFkR6/Yi4jvWbNb8YDzimHYxlluVgGOzddJE8BGDWCzCeBf
qgJMa/JvTQD3NYC7JoCb9GW5nnGbmwu5MZlMfoqiGGEN6/hKNw8i4rOySGVZbuEK+ziNiIc5DR2k
Fz7hMiKmnTQ8Rm8mO0rBl7TfSQXrz2Q+sLuIYTYMR2nVqYdhFwctanDYxXILwErrJv4BbmYyhKy2
aW4AAAAASUVORK5CYII=
}

dict set icons stop {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRChEUD9381gAAACVJREFUOMtjYBhowAhjXGBg+E+K
RgOoXiZKXTBqwKgBg8OAgQcAMocCGNtoSj4AAAAASUVORK5CYII=
}

dict set icons dashboard {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDYiGSYPRAAAAEBJREFUOMtjTEpK+s/AwMAwb948
RgY8AKYOBmDqmRgoBANvAAuxfh28XhgGBjAkJSX9Rw95urqAkRLbqRMGAw4AS0oSio9Xz+YAAAAA
SUVORK5CYII=
}

dict set icons datagen {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQgQkfYvjgAAANZJREFUOMuVkC0OwkAQRt+2VRjO
gWzgACTgMRD8YDAYCFiKJIRwAJK5Ah4MjhBET8SP2RLSdLfLmP2b9/bLGBwlImNgBrTt1QM4qOrp
t89UgAY4AhOHe6eqq+IQVTRMPTDAUkQGPsGC+poXm8TGbgFboAc0AgSdr8DCN6BJeDV+E2xr4I1d
16VhX4BhYmM7YVXNLFCW9IF9FAID2P2m1DOKgHPNz5mIZA7Jy/gmZcF1VaKi4kAYoJumqcnz/For
qICdkvgP2JvEN4e3iLxd70mA4w48XY8fCl5K86jC5XIAAAAASUVORK5CYII=
}

dict set icons savexml {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQgjLiZOmAAAAGxJREFUOMtjZMABkpKS/iPz582b
x4hNHRMDhWDUAAYGRqRQb2BgYKgnUl/jvHnzGhgYGBiYYSLnz58/YGhoyMjAwOBArGYUA4g0BEUz
hgEEDMHQjNUAHIZg1UwQJCUlNUADdxADRvRcR/eUCADKFyn9zNt+xwAAAABJRU5ErkJggg==
}

dict set icons hmenu {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDcOMuVS5gAAAC1JREFUOMtjYBhowJiUlPSfEgOY
GEYBY1JSkgAlBrAwMDC8p9SAj6OxMNRjAQCieQhnacCg+QAAAABJRU5ErkJggg==
}

dict set icons results {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCDsxKDYw1wAAAaFJREFUOMt90z1rlFEQBeBnX4IG
LbTSxsI0frCEgCm0lMQiFirWprqgMREsQoh/wYARgqzJNtNpaaxioVtroRFEE4Igoo0fhRYWxiLa
zMLLsubC5cAw587MOXMbek4pZQTXMYajGf6IDlYi4k09v1EjDmIJV+vxnvMXy5iNiG2oauQnuIbf
uINTGMw7irvYxgzWkmMgX17CWXzCRERs9lRex3opJbLQGBZxo5Ezv87KoxGxWUo5iQWMZ9sdzEfE
VimliVfYg5EqBWugVSM/xwXsw35cxItSyvGIeIf7yZmqsh14mLiAA3iEwziEVRzE7cx5kDhe1aza
6AYTpyPiW0R8zy7hXE/uUPUfq+poF1sN5JIcQzPV7uTM7VJKV5925j9NbCZ+qJIAVxLn8ROX8RVf
cAk/cCtzJhM7FVay3ZlSSjMitnAGj/Er7ypOR8T7UspwarKDdiM3sZUb9hnn0yp9/skw1nAE9yLi
ZncTZ3EiLX1ZSllOqzZqM09m5b14hrl+n2kR07uovoMW5iLiT197ss2p3Iehrtopdjsi3tbz/wHQ
RondcQj1oQAAAABJRU5ErkJggg==
}

dict set icons windock {
iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQQS000BrgAAAFRJREFUGNONj8ENgDAMA6+IvdpZ
bhHaRTILnQxeQIWohF+xfLKVpB48ahFRB88y3P0djkAHsvoJtIgoQOOP1Ho1qXWdcJtagJwmLTuQ
31/cE1cIcAKYghkMIb9+6wAAAABJRU5ErkJggg==
}

dict set icons winundock {
iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcRCQM4R7devwAAAFJJREFUGNN1jsENwCAMA68s1s7i
RQiLeJYyWfsBCbXhPlac6BQkhaQAmLlSRlZJN1B/B7YD6MBJQhnadAlwfAtJzzK2wp5uO3aG+VNq
aLYvoAG865MZpYGZ4wYAAAAASUVORK5CYII=
}

dict set icons task {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QgICxMbA9dmNgAAAIxJREFUOMvFkjEOwyAQBMcWT0yX
bj9i/JFtrTwycpoQXaQzRk6RLREz3AKTpJ2xPIC77aekCmC7lovwAiCJj8D2dGaJcMs8OEEGr7br
fLS59ezBAKV3kqS2nMIjFZYMllQOBW/7msgivHUnSCRx7A24nVYIkq/OEU4vMZF0M/wPjlLC8+1X
BD9P8P+8AMvLRwGIPCC/AAAAAElFTkSuQmCC
}

dict set icons repeat {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QgICxQSNUpIVQAAATtJREFUOMul0sFKllEQBuDn+/gx
6SpqEbkRvQQpsKBbyEVDUhuRokXSoo3QpkVCWRBNK+sOSoLaK9SiRWIiehMmLso2U3581A/9vZtz
zjDvO3PmnUYPETGFm7iAM2iwi3dYzcztTu79pvMYxwrmi/QnfMdD3MMybjUd8lvM4Bse4xW2Smy6
hK+hxQ7O4WhQyitF3sPlzPzaq7yBjYhYw3qRwaD+PI8DXMrMHX/HLMa6gbYG1uDRMHJEPMDdfnxQ
04a1IZVl5hKW+vG2rPqBbSOg9Z9osV/nxKgC7+t+dVSBZzjGYkSc/2eBzPyMpziN9YiYGGLlVETc
7sZ+rfIpvClLD/EEr/Gl8iYxhxu1SNcz88VvFzLzCFewinHcwccSO8QmFor8ssRPOui1OVmVLuJs
5ezjA55n5qdu/k8HXVeB56kVMgAAAABJRU5ErkJggg==
}

dict set icons ban {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}

dict set icons graph {
iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAYAAACqaXHeAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gEaEhE1j1QeTwAAAzNJREFUeNrtmk1LVFEch587lm7a
9QFatRFcHFq0tXURvSEWvdg/KgiRKIoQylFMkCgSERXzLypK5UsRRIs22hc4H6h0WnS0cZyXO3Pv
zHjP3N9u7j1nuM9zX85rgMcRkQvAHeCGqv4uVqbNY/iLwDrQBXQaYzattbstIUBELgFrQLs71Amc
NsZ8sdbmvBYgIleAT8DxglNdwCljzDdr7f7BjGfw10rA76UPmPHyCRCRHmAVOFah6BljzElr7Q9v
BIhIL7ASAn4vZ40xJ6y1PwMP4G8ASzXezNFMwuFvRoAH2MkkGP42sBgBflhVs5mEwt8FFiK0YsOq
mk1kMygi94D5OOATJ0BE7gNzQBAHfKIEiMhDYDZO+MQIEJFHwHTc8IkQICL9wFQ94OsuQESGRCQb
of4AMBnhEsrC17UrLCIvgWGg2xgTWGu3qqz/GHhfT/i6CRCRQWA071BVEkTkKfCu3vB1ESAiL4Cx
IqdCSRCRZ8CbRsDHLsBd/HiZImUlOHnjjYKPVYB7bMPcuaIS3Gsz1kj42AS4D1Y17+wBCe6DOdpo
eCK0rYVN1UStFw7kgGwz4CMLcJ2USZqXSPCRBLju6VSS4WsW4AYm03G8Qs2Er0mAG5LO+gBftQA3
GTHnC3xVAtw01LxP8KEFuAnIKHNwRxI+lAA39bzoI3xFAW7RYTkC/JDr6IwcRXgos5TklpuWIsCP
qOqI+y9qkFB3+JJjAbfQuBJhrPBaVV/t/bDW/jLG5IBzRwm+qAC3xBxmlbVUxlV1sPCgtXY7pISG
wR8S4DYXfIwA/1ZVn5c66SQAdB8F+AMC3LaScpsLKmVCVZ9UKlRGQsPh9wW4DUVrEeCnVHUgbGEn
IciT0BR4gDa3lWyd/xuKqs0M0J+/7yakhC0nYbtZ8ACBiGwCl2us/wF4oKo5EpoMcB34XkPdhaTD
7/cERaQD2ADOh6y3DPSp6i4JT5DXCoSVsArc8gH+0FgghITP/Nt3u4MnCYr0BEtJ2AB6VfUPHiUo
MRYolPAV6Cm149o7AQUSdoGrPsKHmQnqEJF20qRJkyZNmjQ+JhCRXCsLyLT6E5AKSAWkAlIBqYBW
zl9dAloX9zbtEQAAAABJRU5ErkJggg==
}
}

iconicorange {
dict set icons new {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCIzT41XDQAAAFJJREFUOMvt0jsOACEIRdGLcdNU
Y+eysbJS/IRmCl9NDgQQU4xJpCIAphSpFJwk9vlMY8ASOQVc5AaYIrfAgORddb9GdIl+A+8PTicL
T/CAPwAN5dwV/e6JwuYAAAAASUVORK5CYII=
}

dict set icons open {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCogA+qc2wAAADFJREFUOMtj/F/J8J8BC2BsZ2Bk
IAIwMVAIGHG5gFhAsQsGHgx8GIwaMGwMOEmB/mMAewAJl3iazjkAAAAASUVORK5CYII=
}

dict set icons save {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCDgdI3agGQAAAG1JREFUOMvtkbEJgDAUBS8xoJWd
owiulgmymWQWQW3VgLFQQQuLJGLlwS/v4PGF10xAThizMBQAMkLm6kgS+QN7wEZ4LW8hvKYCxkCv
FIbhnNABLvB6r1Gff6EGmpRAdtwNFRCwTxOWiOkOWAE2a8cdAM3VTZIAAAAASUVORK5CYII=
}

dict set icons copy {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCBo6Ic5TUgAAAGdJREFUOMtjYMAB/lcynPxfyXCc
gQBgwSNnxkAEYPxfyfCJgYGBl7GdgRFq8ycGBgZeNHWfGdsZ+KDy/5H5TFgU82KxCKcaDC/AXEIs
YGKgELAghfp/cgyg2AWjBgwbAz6Toe8jjAEAW60U8pbgctQAAAAASUVORK5CYII=
}

dict set icons cut {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAA3XAAAN1wFCKJt4AAAAB3RJTUUH4QcSCCA7c2C9vQAAAVFJREFUOMuN0a1vFVEUBPDf9hVF
0iJqCKSiFBwC02BQlVhkg6Km4gWBueaJClZAWkxRiIYgcPBfQBUCVeiXabCkCSEhoRczyXt53W04
yUk2c2bmnjPLRNVivhY7eqoWO7WYn8Rmpjgr2KjFaod4FRvh9Boc4xzbtRhMiAfYzuy416BpHWAX
d7E+MVoPthvOWNOx6g18xy8sBz7AVdxuWqeXnSCELSxglF7A1rS4c4NsMZdXrwX6ieWmdTbNneky
CHETV9KbXeJeg9R+z/d/nTDAlyQPX3Gvaf291KAWd/AE17GGw4xu4R1+4E3T+nbhhFo8xB6W8CDw
x7RgS9gL90IGrzFqWo8wDPYhDcPMRuGODfLbFvE++E2c4FP6JJhwFqMxG/BPkh7W4ggv8LRpneeB
53hVi985Yz+acYi1uJ+g5vCsab2dCvgxXuIMa03rM/wD38pnOmHORcUAAAAASUVORK5CYII=
}

dict set icons paste {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCssE0fhsQAAADhJREFUOMtj/F/J8J+BAsDEMOQB
I7FhwNjOwDhMw2AIxcJoSsRMkf8rGc4wMDD8oSQM/jAwMPwFAC4bEDT/Kej1AAAAAElFTkSuQmCC
}

dict set icons search {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCUZ23cIHAAAATBJREFUOMuV0z1LnEEUBeBnQpoY
7AO2i7aCtf4BraMQ/GiEwLIqWL2l1dv4FQ0EbRSFbURJsT9DbCVoZ8AfYEhhsa/NXZhddnH3NGdm
4Jw5c+feJENVmEADC6jhIx7Rwo9UetKDlIm/4QSf9cd/1FPpPD/8kIkvQ3yFOYzjE2ZxgzGcVYW1
rgQR+0+IG6n0s9/1VWEbu5FkKpX+dhI0QtwcJIZU2sPvSLKVP2Eh1ofex0HwfG5QQxt3QxjcBte6
ijgC2p2S5AYPwdNDGMwE3+cGrVhvDmGwEXydGxzjH5arwvogZVWo42tsX7o6sSosoRn7Jo6iqCli
b2Ix94uu/JW38hJOowOHQYXvqSfml2yYJiNBZ5iesd/zc69plD+sCis4y0zaI/VBKl1gNeahjZ03
BLVLFshx558AAAAASUVORK5CYII=
}

dict set icons ctext {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCC4ZOIPR1wAAAHVJREFUOMvVkrsNwDAIRM8sFmcs
OnceK/ZkpAgFwok/UoqEBpmTeKfDwC9KGFEYIoziNZrckVyfJ3hNGEXf0TroEVKvB910AKghX1st
/U5TNxuAnRbpzZx6ySulhtxmY68wpAyd+WRXrkIzSb/2J54yWCN8rk7on1AANq0CUAAAAABJRU5E
rkJggg==
}

dict set icons test {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCB0onTa03QAAAI1JREFUOMvtkssNgzAQRN9aFOGk
AEQbKcsVuCzSRiiApAJQLiyHbKQN4mDDNSNZ8h7mafYjmlgA4Zjm4MyjvRqFxplv9r8Dl2KCLyQz
GOhZC7gCvSZayTwM8qpO4MOUJviZgWQGTXRAD0RraxemCd0mkK25RPIluZ5jxRrfjSvikUsKnNQf
8Dmk+QRoWgHaCx/fP6GbyAAAAABJRU5ErkJggg==
}

dict set icons lvuser {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCQJ39spOQAAATNJREFUOMul0z1PljEUxvFfnzy4
mDBo4gcRDYRBBzYJBgY/hCGRwEI6EF6WuqCJEdj8DgQGB0cGBsLq5uRCCGwuKJalTaDU5Ek8S3tf
5zr/tqe9gxEiR++wjitshWSv5sIIxTP41shzITmEQWNeztFFjs5ytFjkY/xsACt1MrhV/AYf8AhP
8DlH8yH5hU8NYOIeAMudE1Tta6OHHuBpB/CsjD8a/bQHyB1AXelvo3/sAU47gJMyjuMcl1gKyX41
DG+ZtzHdALYhJGelsbXhY4jYDZ0Hs1aOsxmSnSb/EC+xgec4CDl6jLd4H5I/TcEQq9gLyWWOdou3
xu8hvuA1ZnO0gaOygxdlpclyGwvcA4wN8ap8THXuu0b1fG8Tg6aR/4oHpZnXbWKU4rsPI939AQf+
M24AxjBLP90uAqAAAAAASUVORK5CYII=
}

dict set icons runworld {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCB4J+nL3QAAAAFVJREFUOMtjYBg04H8lw4H/lQwO
pOpjRDLgP5R5kIGBoYGxneEAuQYwkGIQPgOIMogYA/AaRIoBWA1iojT2WEhQi9ULLORqJMYAoqKR
hVyNVEvKAw8A3w0rHBqabYQAAAAASUVORK5CYII=
}

dict set icons boxes {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCB8Gc9bbkAAAAF9JREFUOMvt0jEOhDAMRNFnNgem
zQloECcOCg1BNFtsshINv7PkkUdfjpqtmPHxGzu2qFnpCDdKauFYBNSs3udvnHtpMki0i70MN0hX
lT4HXgd/cjD0yhM2lJ4wVo9zAAqZJQ3yd3+XAAAAAElFTkSuQmCC
}

dict set icons pencil {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCkVfnQLOwAAAKdJREFUOMvVkksSgjAQRF9SXMGj
Ko6/AILR8szWuOBTIQplYOXsupM31TMJLCgVtio8AMwCOAfunaxtIiwBDPCyCfARuAVWaTyFnbjs
VCgCfQbqGAbIvsAXaA9VWqvXMfyxRBVOwHVmkhE8aqDCAWhS4KGBCnvAB77roldzMECmwi6CK+Nb
UAULmCm4X+Im0I3xuCGep/z1jZ8qow/yR2VU0DUN7NoEbwHzOwo5DdLEAAAAAElFTkSuQmCC
}

dict set icons autopilot {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCU3B6EF0wAAAKVJREFUOMut07sRgkAUheFvGQPa
wNRWtBUNlQrAUFvBWgy1DbI1UGcQ2FEGT7g799z/voKXYimaoFAJkJmpRco5pT7p/wi+ZU4p66Bt
Ymk91SC8gnNcEbEKlXak9oZBgsub4IACS+wTyXZ8GLfYZrEcBB1iqRiZzg3HzlMdKvcMJ+Sdjxzn
BEWNOwOz53x/2cZ+sxeTu15pZi1Sn/T/tzD1KmcTPAAlBDN5AJZpDAAAAABJRU5ErkJggg==
}

dict set icons distribute {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCB8p2AfmyQAAAMxJREFUOMvNkbEKwjAQhr9rgz6D
m5Ozq4ODOvogOrpmaK0gBKSIL+Ps47i7iKDEpSk1JC3i4rddjv+/P3diNSWwAVIaiEEIYDWFGApX
JyFxB1ur2blCOXHLxDGwBubAsHrOrUbEkKvYGKvpAydgBUHzzGpERcQ94AwsOr7ziCU4NMQvr+f2
lYlhrwLTR8AMWAIXMdy9vnVit0SfCTAVwy2SrhbXjpWrqwdfnJTEfxDD9SeDlrN+JP3aIIaqzpSG
3AM8QwmOoUZEXPJ3vAFGqTqCjyEGhQAAAABJRU5ErkJggg==
}

dict set icons benchmark {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCBwPIScw9wAAAVxJREFUOMuV0r1rVUEQBfDfmlRR
awMBK7EQtUhMFQixtxHxqxELKzFRwWb/gq3UQNBCBDsRgpIHDwQrC7USG6uQ1IKFTbBLZFNknuy7
3IBOs3vn7jkzc+YknajZnp5IxWRfvi854T/iSKf6Saxiu0l/xULPu/EOanYbzzDVKXIem/FmAnfx
dqyDmt3CqwBvYAnHcQxzqfhVsxMY4FMqfvzVpmYzUeEoHqXicY+wC3iDe6kYdDVYCfC7Q8AP8BFP
UjGo2UzNFlsNLsV9tQOcwkvcxPNUPK3ZOXzDd8yOCE41arfxIdR/H12K7UziTDtCHRXtEOziC66l
4k93snaELZzFHD43zrvY45sLcW62HQzjfv8fjPcwzmFLsIbfuFqz5cOQsY3L2AnMQafx8wZex/d6
bGQk6nxUvhKzX0/F+hhBQ/IiHNgXO7jTgscIgmQay+GN041gQ6yl4meXdR/fzF4vi1J65QAAAABJ
RU5ErkJggg==
}

dict set icons driveroptim {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCAHXA/BOgAAAIFJREFUOMvNkdENgCAMRF/RFXQV
4xgOwRBM4AqOZNxEHaL+SGIMIkpMvD+g73q0wknq6IABqIlrBawEDOYE2GsxgUsPN0B7Y1CXVy/S
M+2JojJkKtugvCuQHvk0QWiNmgTuyfKHqA5N7frzNaqjAYo3BitQAeMDbj5+wQLLQ9j6wwbJqhor
EGoJOgAAAABJRU5ErkJggg==
}

dict set icons vuseroptim {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCQJ39spOQAAATNJREFUOMul0z1PljEUxvFfnzy4
mDBo4gcRDYRBBzYJBgY/hCGRwEI6EF6WuqCJEdj8DgQGB0cGBsLq5uRCCGwuKJalTaDU5Ek8S3tf
5zr/tqe9gxEiR++wjitshWSv5sIIxTP41shzITmEQWNeztFFjs5ytFjkY/xsACt1MrhV/AYf8AhP
8DlH8yH5hU8NYOIeAMudE1Tta6OHHuBpB/CsjD8a/bQHyB1AXelvo3/sAU47gJMyjuMcl1gKyX41
DG+ZtzHdALYhJGelsbXhY4jYDZ0Hs1aOsxmSnSb/EC+xgec4CDl6jLd4H5I/TcEQq9gLyWWOdou3
xu8hvuA1ZnO0gaOygxdlpclyGwvcA4wN8ap8THXuu0b1fG8Tg6aR/4oHpZnXbWKU4rsPI939AQf+
M24AxjBLP90uAqAAAAAASUVORK5CYII=
}

dict set icons mode {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCYfGTn+6gAAAEFJREFUOMtj/F/J8J8BD2BsZ2DE
J8/EQCEYQgb8r2T4jy28hkEYsBCKZ3xhQh0X4DKZbmHASK5GqoUBI7E20SwMAIZvEnUXvqR4AAAA
AElFTkSuQmCC
}

dict set icons option {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCDgyiKedQAAAAT5JREFUOMuV07tKJUEQBuCvDdRA
Ofgkijfwknt5ASPxBTQzGVmEFaRhowXxCVbFNxANBTneQDAWfARNZDku2Jv0QDuMwikY+Kv6r576
q6uCLyxVZnGT3dkQ3bXxBoqE0VQZL84223CqTKTKSO2HHBzBOeZxhQvsYCjzetjHCuZwidUQvdUX
zOBWfzYZoocByPru+kjuhujhUw9wVuBe1j2GTsa9Nm5IlSlsYQ3DddNCdNh4lU0cZPcvTnEYUiW1
lDgWotfGBR0+x5oSSvtoiYWv5mAxl/OviK+3cDcK/I4TLISixJ/YLZq4jT/5zxv4hcF8/iNE+00J
SwUeyg17xQt+F8mw3JzEKdz3OUjjIXqsK3gqFucae1lnqXmvGLYunpvb18mV1P5xqqT8HRXx6VQZ
/fZpMrFeLJgPUbeN9x8kI19w+Gqs6wAAAABJRU5ErkJggg==
}

dict set icons driveroptlo {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCDgAQHDMwAAAAFtJREFUOMut0zEOwDAIA0DXv86U
dsqz6R4FMKWMQT6hIICtbOBGp2zAKgid96kiDHoSwqSfIhSmDBGKf+UiLCzoiBDNqgDPtb5PcAyr
gBtWgDCcAWn4l2NC95xfogQjXk/kcwMAAAAASUVORK5CYII=
}

dict set icons tick {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCMg0ignkgAAALtJREFUOMvF08FtwjAUANDnNIN0
koohAqpa9VCJJTxBlihCAqm5wLFDdAsQXQPci4tAhBB6AJ8s678v+/9v7r3CNcEpKjDDV6g1UFyJ
J3jFPEVvvW+Q8QfeD453eCn+iWGD75CDSsyxDLVFD7zGINRWRcYNntGkaNgXQ0hxj//WFmM8XcJQ
Yokq7+EB05ZynOB9F1JU5WeUZ2rZio/a2JHkLD6Zg5Yknbh1kFI0wid+LuGu4Rml6PEmv/EXhhtG
dKcRHmUAAAAASUVORK5CYII=
}

dict set icons cross {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCBkfQefU1gAAATBJREFUOMuN00FuUzEQxvGfX6C9
QA/AmjO8BRegUislLSGgpKtewSd4l2groUiJFDVCAi4BpwCFHAIEmEWdyHnkpczO4/nP2J8/B0jR
E0yxDI17HZGiCu/wMTQWUGV4jkvMU9Q/AN9ihFmKXkNIcQtv4jfehMZ8Dzwu6v5gWGGJX8VGD9MU
vS3guxYMK3wOuaifr9FrTbhGzUOzIr7hRWh8DcUxX2Uhew7HFoZqk813HufJ/wVD2KP2VRasHWvU
JbxzgkKwumP6CZ63k1ULvsGko8Ex3qfo5T8NDsBr/CjWR1im6GzboDDJZI9gNc7xs8g/xSJFg40T
p9menWqn6BT3GS4dO6zwKS+6n6rxARctx37Hl40TR/mXrdpw65UGmGV4ty5FFyl69ogLpWhQ1v0F
UfBwRrwHTS4AAAAASUVORK5CYII=
}

dict set icons clock {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCBsltd1v5gAAAWRJREFUOMuN079qVFEQBvDfXNRN
Idr4AKYOumB8AN00AR/BtBr/dGJzn+A0RkixrjZ2+ghJkzyBGP+QxE4kRUpb3SBem1k4XDfRgcOB
mW/ONzPfnNCzrjXEA4xwNd3fsIuXUXyu8VElLmAT92p//31M8CSKKTRV8jbu4yee4QYW8izjOaZ4
hK3McS5f3sQtHGE1ii895j3sda3XSTTCBh5H9vwhmZdnyV0r8AO/orhYtbqE97iAYZMDC4xr5ig6
DLIFlf8ALzJnvcly4K3/tzd5rzSVVIengKNrXer5ZtjF5h9Mn1Kpna51ZR6gySWBpTnxET7icg5N
D/u1yQ2Du3/VXnzHKm5HcVyF1vLeja51PVmmuJlTPtW61jW8w3kMm9ztScq1nTqflbyV8o6j2I8M
DDIwyoWapFSHVc9ruTMD7OBOFCf9z7SBh2d8pt8Y42kUJ+YBs8x1rGBxNu0c9qso9mv8Hw02Zksp
qolfAAAAAElFTkSuQmCC
}

dict set icons running {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCBwubU4gqQAAAPBJREFUOMuV0rFKA0EQxvHfXs43
CigWvoQoqCREsJYoCF5nIWwsRPEFFEULyQvYWqTygYLEnE2Ey5LcndPN7Pef2f12goYoC7sYooub
EF1Vz0MDfIvzRToKUZFqQsPkcaW0EaJZqstqLjDUIuoadFv4c1HXYN4AX+I6r9F8YaeST8tlCzuY
5Gu672M7KXdWSO+yFfAB3pA3WHAfonGWwEd4SabN8IkpvjHBXojOlvagLPTwlPzMDw5D9F77jWVh
sAbu1cEQykIfjwk8Rz9Er20W6QGb2KrAx23gvwZhYVoHJU5C9Kxl5DjFx+LNg//A8AvtcT5TZkOv
JwAAAABJRU5ErkJggg==
}

dict set icons oneuser {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCIM+et6MAAAAOFJREFUOMul0q1KBVEUxfHfmSQK
Bt9CTSKIoMmPZrtNNAuCxSLzBAcEm5i0KYhg0Tcw3KJG73PobVrGcsIwnDt3dFY7+6z9Z8NaQUZV
aQEXGKDCI05D9Nn0hszyDIZYaXy9YyNE3/VhkTngJLMMqzhuDnOAfZN10AWw2AJY6gL4k3KAUYv/
owvgrgVw2wVwmSJr6hVXUwEp5x3cYIwvXGM3RD/ZIlWlZZxjE0chup/Q0MN04QvOQjQKaXmI+Zr3
IRnf0nstFWxQ84yxHqrSM/b+meJTga0eNdguMNsDMNe7ib8R+y0i+l5ymwAAAABJRU5ErkJggg==
}

dict set icons stop {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCQ18LRVvgAAACVJREFUOMtjYBhowAhj/K9k+E+S
xnaIXiZKXTBqwKgBg8OAgQcApjQDGCxqtAcAAAAASUVORK5CYII=
}

dict set icons dashboard {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCBoM7nTGywAAAEBJREFUOMtj/F/J8J+BgYGBsZ2B
kQEPgKmDAZh6JgYKwcAbwEKsXwevF4aBAQz/Kxn+o4c8XV3ASInt1AmDAQcA4W0QgO6QOuQAAAAA
SUVORK5CYII=
}

dict set icons datagen {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCC8hCZpYCAAAAM9JREFUOMuVkDEOwjAMRV+qTl04
BzPcAHYWEAdgYWEBgZSJdqoqhDgAh2CHAyDEmSAMuKiK4rRYiuLEfj/ONyjhLHNgBQzk6gmcTMml
2WcCoAHOwELRPpiSXX1IAg3LCAywdZZJTGBDe6zrJJWx+0AFjICsg8DwJyDwHejRPbLmBFULXMi+
98y+AdNUxlZhU5IL4IuMgWPSBQaQvPB6ZglwbXk5d/abB0TeUacEdrLyUI+Jwb5x/rdUAQUOe/Mn
rE4S88E5i9PqaQeNB/DSih95nEKggoybxgAAAABJRU5ErkJggg==
}

dict set icons savexml {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCsTpSHMjAAAAF5JREFUOMvtk7sKgDAMRU/860zG
qZ99XYqv1lIVxMELGQI5ZwiJcRI52vaWsNrcwMP8AtbNyglg7OQmS8ROcEGywIWgQ7KDq4KGpICb
kRNylCtubThLgk/Hjl/3+iXOzo0iWPm9cqYAAAAASUVORK5CYII=
}

dict set icons hmenu {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCQeXAis/gAAAC1JREFUOMtjYBhowPi/kuE/JQYw
MYwCxv+VDAKUGMDCwMDwnlIDPo7GwlCPBQDA/Ald4W/EUwAAAABJRU5ErkJggg==
}

dict set icons results {
iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCB4lyKqbowAAAZpJREFUOMt9071rFVEQBfDfXcQE
LWKVNBamEnmEgCm0lBcLRVSsTasxESxEIvsXXANGCPJMXmOnpbGKhb5aGyOIJgQhiDZ+FFpYmBRZ
m3mwLDELlwOz58zMnTM3aXxVaRw30MaxCH9GD8spe1/np5pwEIu4Vo8382MJt1O2DUVN/ALX8Rf3
cRKDcSbwANuYxWpoHIjMiziDLziXso1G5TWsVaXHUaiNBdxMced3UXkiZRtV6QTmMRlt9zCXss2q
1MJbHMR4EQNL6NTEr3ERh3AYl/CmKh1P2Uc8Cs10Ee3A08B5DOEZRjCMFRzBveA8CZwsalat94OB
Myn7kbKf0SWcbXBHi/9YVUf72KqIJYFWYC+wW5WGq9IIuhF72eBuFTXB1cA5/MYVfMc3XMYv3A3O
VL9YgeVod7YqtVK2idN4jj9xVnAqZZ+q0ljMZBfdFJvYiQ37ivNhlT3eyRhWcRQPU3arn2AgfrRj
oZbCqvXanaei8gBe4ULKdpqPaQEz+0x9Fx3cSdnOnvZEm9OxD6P9acewuyn7UOf/A/bdfXC6irBt
AAAAAElFTkSuQmCC
}

dict set icons windock {
iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCoK2FFVDQAAAFNJREFUGNONj8EJwDAMA8+leyVr
+VX7lbWaydxXUhMaqF4WOiQsoQSvXBqWPEe6+xpmoAMl9BtwaVTA+aNQbDSFYueGu0KpQJFNyw2U
9Ys5MUKAB4yzF6aI8M/QAAAAAElFTkSuQmCC
}

dict set icons winundock {
iVBORw0KGgoAAAANSUhEUgAAAAgAAAAICAYAAADED76LAAAABmJLR0QA/wD/AP+gvaeTAAAACXBI
WXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4QcSCCkuz3/iHwAAAFRJREFUGNN1jUEOwCAIBAc/Zr/F
STn5LX0ZPZQ2xpS5bNjAgCvdlQ7w5k6JbK5MoJ0LEpcTqAAynu4zhLaSIGfhim+jFXKWDHpmWPH2
12AyuAADuAHcaxjk5QL69wAAAABJRU5ErkJggg==
}
}
}
return [ set icons ]
}
