/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.firebirdsql.ds.ReflectionHelper;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdConnection;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.ObjectCloseTraceException;
import org.firebirdsql.pool.PoolDebugConfiguration;
import org.firebirdsql.pool.StatementHandler;
import org.firebirdsql.pool.XConnectionManager;
import org.firebirdsql.util.SQLExceptionChainBuilder;

class PooledConnectionHandler
implements InvocationHandler {
    private static final boolean LOG_REENTRANT_ACCESS = PoolDebugConfiguration.DEBUG_REENTRANT;
    private static Logger logChannel = LoggerFactory.getLogger(PooledConnectionHandler.class, false);
    private static final Method CONNECTION_PREPARE_STATEMENT = ReflectionHelper.findMethod(Connection.class, "prepareStatement", new Class[]{String.class});
    private static final Method CONNECTION_PREPARE_STATEMENT2 = ReflectionHelper.findMethod(Connection.class, "prepareStatement", new Class[]{String.class, Integer.TYPE, Integer.TYPE});
    private static final Method CONNECTION_PREPARE_STATEMENT3 = ReflectionHelper.findMethod(Connection.class, "prepareStatement", new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE});
    private static final Method CONNECTION_PREPARE_STATEMENT_GENKEYS1 = ReflectionHelper.findMethod(Connection.class, "prepareStatement", new Class[]{String.class, Integer.TYPE});
    private static final Method CONNECTION_PREPARE_STATEMENT_GENKEYS2 = ReflectionHelper.findMethod(Connection.class, "prepareStatement", new Class[]{String.class, int[].class});
    private static final Method CONNECTION_PREPARE_STATEMENT_GENKEYS3 = ReflectionHelper.findMethod(Connection.class, "prepareStatement", new Class[]{String.class, String[].class});
    private static final Method CONNECTION_CREATE_STATEMENT = ReflectionHelper.findMethod(Connection.class, "createStatement", new Class[0]);
    private static final Method CONNECTION_CREATE_STATEMENT2 = ReflectionHelper.findMethod(Connection.class, "createStatement", new Class[]{Integer.TYPE, Integer.TYPE});
    private static final Method CONNECTION_CLOSE = ReflectionHelper.findMethod(Connection.class, "close", new Class[0]);
    private static final Method CONNECTION_COMMIT = ReflectionHelper.findMethod(Connection.class, "commit", new Class[0]);
    private static final Method CONNECTION_ROLLBACK = ReflectionHelper.findMethod(Connection.class, "rollback", new Class[0]);
    private static final Method CONNECTION_IS_CLOSED = ReflectionHelper.findMethod(Connection.class, "isClosed", new Class[0]);
    private Connection connection;
    private XConnectionManager owner;
    private Connection proxy;
    private boolean closed;
    private ObjectCloseTraceException closeStackTrace;
    private boolean invokeEntered;
    private Set<StatementHandler> openStatements = new HashSet<StatementHandler>();

    public PooledConnectionHandler(Connection connection, XConnectionManager owner) throws SQLException {
        this.connection = connection;
        this.owner = owner;
        Class[] implementedInterfaces = ReflectionHelper.getAllInterfaces(connection.getClass());
        this.proxy = (Connection)Proxy.newProxyInstance(PooledConnectionHandler.class.getClassLoader(), implementedInterfaces, (InvocationHandler)this);
    }

    public Connection getProxy() {
        return this.proxy;
    }

    public XConnectionManager getManager() {
        return this.owner;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void deallocate() throws SQLException {
        this.handleConnectionClose(false);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (LOG_REENTRANT_ACCESS && this.invokeEntered && logChannel != null) {
                logChannel.warn("Re-entrant access detected.", new Exception());
            }
            this.invokeEntered = true;
            if (this.closed) {
                if (CONNECTION_IS_CLOSED.equals(method)) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                if (CONNECTION_CLOSE.equals(method)) {
                    Class<Void> clazz = Void.TYPE;
                    return clazz;
                }
                FBSQLException ex = new FBSQLException("Connection " + this + " was closed. See the attached exception to find the place " + "where it was closed");
                ex.setNextException(this.closeStackTrace);
                throw ex;
            }
            if (this.owner != null && !this.owner.isValid(this)) {
                throw new SQLException("This connection owner is not valid anymore.");
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT)) {
                String statement = (String)args[0];
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, 1003, 1007, 2);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT2)) {
                String statement = (String)args[0];
                int resultSetType = (Integer)args[1];
                int resultSetConcurrency = (Integer)args[2];
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, resultSetType, resultSetConcurrency, 2);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT3)) {
                String statement = (String)args[0];
                int resultSetType = (Integer)args[1];
                int resultSetConcurrency = (Integer)args[2];
                int resultSetHoldability = (Integer)args[3];
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, resultSetType, resultSetConcurrency, resultSetHoldability);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT_GENKEYS1)) {
                String statement = (String)args[0];
                Integer returnGeneratedKeys = (Integer)args[1];
                if (returnGeneratedKeys == 1) {
                    PreparedStatement preparedStatement = this.handlePrepareStatement(statement, null, null);
                    return preparedStatement;
                }
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, 1003, 1007, 2);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT_GENKEYS2)) {
                String statement = (String)args[0];
                int[] keyIndexes = (int[])args[1];
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, keyIndexes, null);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT_GENKEYS3)) {
                String statement = (String)args[0];
                String[] keyColumns = (String[])args[1];
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, null, keyColumns);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_CREATE_STATEMENT)) {
                Statement statement = this.handleCreateStatement(1003, 1007);
                return statement;
            }
            if (method.equals(CONNECTION_CREATE_STATEMENT2)) {
                int resultSetType = (Integer)args[0];
                int resultSetConcurrency = (Integer)args[1];
                Statement statement = this.handleCreateStatement(resultSetType, resultSetConcurrency);
                return statement;
            }
            if (method.equals(CONNECTION_COMMIT)) {
                this.handleConnectionCommit();
                Class<Void> resultSetType = Void.TYPE;
                return resultSetType;
            }
            if (method.equals(CONNECTION_ROLLBACK)) {
                this.handleConnectionRollback();
                Class<Void> resultSetType = Void.TYPE;
                return resultSetType;
            }
            if (method.equals(CONNECTION_CLOSE)) {
                this.handleConnectionClose();
                Class<Void> resultSetType = Void.TYPE;
                return resultSetType;
            }
            Object resultSetType = method.invoke((Object)this.connection, args);
            return resultSetType;
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SQLException && this.owner != null) {
                this.owner.connectionErrorOccured(this, (SQLException)ex.getTargetException());
            }
            throw ex.getTargetException();
        }
        catch (SQLException ex) {
            if (this.owner != null) {
                this.owner.connectionErrorOccured(this, ex);
            }
            throw ex;
        }
        finally {
            this.invokeEntered = false;
        }
    }

    synchronized PreparedStatement handlePrepareStatement(String statement, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.getManager().getPreparedStatement(statement, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    synchronized PreparedStatement handlePrepareStatement(String statement, int[] keyIndexes, String[] keyColumns) throws SQLException {
        return this.getManager().getPreparedStatement(statement, keyIndexes, keyColumns);
    }

    synchronized Statement handleCreateStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement result = this.connection.createStatement(resultSetType, resultSetConcurrency);
        StatementHandler handler = new StatementHandler(this, result);
        this.openStatements.add(handler);
        return handler.getProxy();
    }

    public synchronized void forgetStatement(StatementHandler handler) {
        this.openStatements.remove(handler);
    }

    synchronized void closeOpenStatements() throws SQLException {
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        ArrayList<StatementHandler> copyStatements = new ArrayList<StatementHandler>(this.openStatements);
        for (StatementHandler handler : copyStatements) {
            try {
                handler.getWrappedObject().close();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        this.openStatements.clear();
        if (chain.hasException()) {
            throw chain.getException();
        }
    }

    synchronized void handleConnectionClose() throws SQLException {
        this.handleConnectionClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void handleConnectionClose(boolean notifyOwner) throws SQLException {
        try {
            this.closeOpenStatements();
            if (this.connection.getAutoCommit() && this.connection.isWrapperFor(FirebirdConnection.class) && this.connection.unwrap(FirebirdConnection.class).isUseFirebirdAutoCommit()) {
                this.connection.setAutoCommit(false);
                this.connection.setAutoCommit(true);
            }
        }
        finally {
            if (this.owner != null && notifyOwner) {
                this.owner.connectionClosed(this);
            }
            this.closed = true;
            this.closeStackTrace = new ObjectCloseTraceException();
        }
    }

    synchronized void handleConnectionCommit() throws SQLException {
        this.connection.commit();
        this.getManager().connectionCommitted(this);
    }

    synchronized void handleConnectionRollback() throws SQLException {
        this.connection.rollback();
        this.getManager().connectionRolledBack(this);
    }
}

