#!/usr/bin/bash

cd `dirname $0`
dir=`pwd`
workdir="$dir/workdir"
mkdir -p  ${workdir}
cd $workdir
rebuildrpm()
{
    for filename in `ls $1`
    do
      echo "$filename"
      cd $workdir
      mkdir $filename
      cd $filename
      filefull=$1/$filename
      rpmname=`rpm -qpi $filefull | grep Name | awk '{print $3}'`
      rpmversion=`rpm -qpi $filefull | grep Version | awk '{print $3}'`
      pkg_arch=`echo ${filename} | awk -F '.' '{print $(NF-1);}'`
      echo "$filename  pkg_arch: $pkg_arch"
      yum install ${rpmname}.${pkg_arch}  -y
      pwd
      rpmrebuild -s ${rpmname}.spec ${rpmname}.${pkg_arch}
      echo "rpmrebuild -s ${rpmname}.spec ${rpmname}.${pkg_arch}"
      #xiugai spec
      sed -i "s/x86_64/aarch64/g" ${rpmname}.spec
      sed -i "s/x86-64/aarch64/g" ${rpmname}.spec
      sed -i "s/GLIBC_2.14/GLIBC_2.17/g" ${rpmname}.spec
      sed -i "s/GLIBC_2.2.5/GLIBC_2.17/g" ${rpmname}.spec
      #jieya rpm
      #mkdir rpmfile
      #cd rpmfile
      #rpm2cpio $filefull | cpio -idv
      #yidong wenjian dao rpmbuild
      #builddir=/root/rpmbuild/BUILDROOT/${rpmname}-${rpmversion}.aarch64
      #mkdir -p $builddir
      #mv * $builddir
      #build
      #cd ..
      #rpmbuild -ba ${rpmname}.spec
    done
}

buildrpm()
{
  for filename in `ls $1`
    do
      cd $workdir
      cd $filename
      filefull=$1/$filename
      rpmname=`rpm -qpi $filefull | grep Name | awk '{print $3}'`
      rpmversion=`rpm -qpi $filefull | grep Version | awk '{print $3}'`
      pwd
      #解压 rpm
      mkdir rpmfile
      cd rpmfile
      rpm2cpio $filefull | cpio -idv
      #移动文件到rpmbuild
      builddir=/root/rpmbuild/BUILDROOT/${rpmname}-${rpmversion}.aarch64
      mkdir -p $builddir
      mv * $builddir
      #开始build
      cd ..
      rpmbuild -ba ${rpmname}.spec
    done
}

case $1 in
   "rebuild")
     rebuildrpm $2
     ;;
   "build")
     buildrpm $2
     ;;
   *)
     echo "Usage: when on x86 run:"
     echo "  $0 rebuild yrrpmdir"
     echo "When on aarch64 run:" 
     echo "$0 build yrrpmdir"
     ;;
esac
