#! /bin/sh
touch result/JarResult.log
touch result/DirResult.log
touch result/BinResult.log
touch result/out.csv
suffix="jar"
x86_name="x86_64"
unzipRecusive()
{
    for filename in `ls $1`
    do
        #echo $filename
        #suffix="jar"
        filefull=$1/$filename
        if [ -d  $filefull ]
	then
            dirname="$(basename ${filefull})"
            if [[ "$dirname" =~ $x86_name ]]
            then
               echo "$filefull" >> result/DirResult.log
            fi
            unzipRecusive "$filefull" 
        else
 
            if [ "${filename##*.}" = "$suffix" ]
            then
		./checkJar.sh "$filefull" 
            elif [[ "${filename##*.}" = "so" || "${filename##*.}" = "a" ]]
            then
                echo "$filefull" >> result/BinResult.log
            else
                fileinfo1=`file ${filefull}`
                fileinfo=`echo $fileinfo1 | awk -F ":" '{print $2}'`
                # [ "`readelf -h \"${filename}\" 2>/dev/null|grep Machine`" != "" 
		if [[ $fileinfo =~ "x86" && $fileinfo =~ "executable"  ]]
		then
		    echo "$filefull" >> result/BinResult.log
		fi
	    fi
        fi
    done
}
addCheckInfo()
{
   echo "------------------------" >> $1
   echo "------------------------" >> $1
   echo "------------------------" >> $1
   echo "$2 `date '+%Y-%m-%d %H:%M:%S'` check result:" >> $1
}

if [ "$1" == "" ]; then
    echo "usage:./search_so.sh path_to_search_jars"
    exit 1
fi

addCheckInfo "result/JarResult.log" $2
addCheckInfo "result/BinResult.log" $2
addCheckInfo "result/DirResult.log" $2

unzipRecusive "$1"
#sort -n result/JarResult.log | uniq > tmp
#mv -f tmp result/JarResult.log
sort -n result/out.csv | uniq > tmp
mv -f tmp result/out.csv
